/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.systemmanagement.DistributedSystemListener;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer.SystemElementItemProviderAdapterFactory;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class SystemContentProvider
extends AdapterFactoryContentProvider
implements DistributedSystemListener {
    private static ComposedAdapterFactory systemAdapterFactory = new ComposedAdapterFactory(SystemContentProvider.createFactoryList());
    private BaseWorkbenchContentProvider workbenchContentProvider = new BaseWorkbenchContentProvider();

    public SystemContentProvider() {
        super((AdapterFactory)systemAdapterFactory);
        SystemManager.INSTANCE.addWorkspaceListener((DistributedSystemListener)this);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == null || parentElement instanceof IWorkspaceRoot) {
            return SystemContentProvider.getProjects();
        }
        if (parentElement instanceof IResource) {
            return this.workbenchContentProvider.getChildren(parentElement);
        }
        return super.getChildren(parentElement);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            return SystemManager.INSTANCE.getSystemForName(((IProject)element).getName()) != null;
        }
        return super.hasChildren(element);
    }

    private static List<AdapterFactory> createFactoryList() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        factories.add((AdapterFactory)new SystemElementItemProviderAdapterFactory());
        factories.add((AdapterFactory)new DataItemProviderAdapterFactory());
        return factories;
    }

    private static Object[] getProjects() {
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = myWorkspaceRoot.getProjects();
        ArrayList<Object> list = new ArrayList<Object>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.getName().equals("Tool Library")) {
                AutomationSystem system = SystemManager.INSTANCE.getSystemForName(project.getName());
                if (system != null) {
                    list.add(system);
                } else {
                    list.add(project);
                }
            }
            ++n2;
        }
        return list.isEmpty() ? null : list.toArray();
    }

    public void distributedSystemWorkspaceChanged() {
        if (this.viewer != null && this.viewer.getControl() != null && this.viewer.getControl().getDisplay() != null) {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SystemContentProvider.this.viewer.refresh();
                }
            });
        }
    }
}

