/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.systemmanagement.contentprovider.SystemContentProvider;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer.SystemLabelProvider;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class NewElementPage
extends WizardPage {
    private Text text;
    private AutomationSystem system;
    private TreeViewer treeViewer;

    protected NewElementPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectContainer(composite);
        this.createFileNameGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createFileNameGroup(Composite composite) {
        Label l = new Label(composite, 0);
        l.setText(Messages.NewElementPage_ElementNameLabel);
        l.setLayoutData((Object)new GridData(768));
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewElementPage.this.setPageComplete(NewElementPage.this.validatePage());
            }
        });
        this.text.addVerifyListener((VerifyListener)new IdentifierVerifyListener());
    }

    protected void createProjectContainer(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(Messages.NewElementPage_ParentSystemLabel);
        l.setLayoutData((Object)new GridData(768));
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)new SystemContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SystemLabelProvider());
        this.treeViewer.setInput(new Object());
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        if (this.system != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.system));
        }
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewElementPage.this.setPageComplete(NewElementPage.this.validatePage());
            }
        });
    }

    protected boolean validatePage() {
        if (this.text == null || this.text.getText().isEmpty()) {
            this.setErrorMessage(Messages.NewElementPage_ErrorMessage_EmptyElementName);
            return false;
        }
        if (this.getSelectedSystem() == null) {
            this.setErrorMessage(Messages.NewElementPage_ErrorMessageNoSystemSelected);
            return false;
        }
        String result = this.validateElementName(this.text.getText());
        this.setErrorMessage(result);
        return result == null;
    }

    public abstract String validateElementName(String var1);

    public String getFileName() {
        return this.text.getText();
    }

    public void setFileName(String template) {
        if (this.text != null) {
            this.text.setText(template);
        }
    }

    public AutomationSystem getSelectedSystem() {
        return (AutomationSystem)((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    public void setSystem(AutomationSystem system) {
        this.system = system;
    }
}

