/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportUtils {
    private ImportUtils() {
    }

    public static VarDeclaration parseParameter(Node node) throws TypeImportException {
        Attribute p = LibraryElementFactory.eINSTANCE.createAttribute();
        VarDeclaration var = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        NamedNodeMap map = node.getAttributes();
        Node name = map.getNamedItem("Name");
        if (name == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_ParameterNotSet);
        }
        p.setName(name.getNodeValue());
        var.setName(name.getNodeValue());
        Node value = map.getNamedItem("Value");
        if (value == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_ParameterValueNotSet);
        }
        p.setValue(value.getNodeValue());
        Value val = LibraryElementFactory.eINSTANCE.createValue();
        val.setValue(value.getNodeValue());
        var.setValue(val);
        Node comment = map.getNamedItem("Comment");
        if (comment != null) {
            p.setComment(comment.getNodeValue());
            var.setComment(comment.getNodeValue());
        }
        return var;
    }

    public static List<VarDeclaration> parseInputVariables(Node node) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        ArrayList<VarDeclaration> varDecl = new ArrayList<VarDeclaration>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("VarDeclaration")) {
                VarDeclaration var = ImportUtils.parseVarDeclaration(n);
                var.setIsInput(true);
                varDecl.add(var);
            }
            ++i;
        }
        return varDecl;
    }

    public static List<VarDeclaration> parseOutputVariables(Node node) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        ArrayList<VarDeclaration> varDecl = new ArrayList<VarDeclaration>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("VarDeclaration")) {
                VarDeclaration var = ImportUtils.parseVarDeclaration(n);
                var.setIsInput(false);
                varDecl.add(var);
            }
            ++i;
        }
        return varDecl;
    }

    public static VarDeclaration parseVarDeclaration(Node n) throws TypeImportException {
        Node comment;
        NamedNodeMap map = n.getAttributes();
        VarDeclaration v = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        Node name = map.getNamedItem("Name");
        if (name == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_InputVariableNameNotDefined);
        }
        v.setName(name.getNodeValue());
        Node type = map.getNamedItem("Type");
        if (type != null) {
            DataType dataType = DataTypeLibrary.getInstance().getType(type.getNodeValue());
            v.setTypeName(type.getNodeValue());
            if (dataType != null) {
                v.setType(dataType);
            }
        } else {
            throw new TypeImportException(Messages.ImportUtils_ERROR_InputVariableTypeNotDefined);
        }
        Node arraySize = map.getNamedItem("ArraySize");
        if (arraySize != null) {
            try {
                v.setArraySize(Integer.parseInt(arraySize.getNodeValue()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new TypeImportException(Messages.ImportUtils_ERROR_Arraysize_NumberFormat);
            }
        } else {
            v.setArraySize(-1);
        }
        Node initialValue = map.getNamedItem("InitialValue");
        if (initialValue != null) {
            Value varInitialization = LibraryElementFactory.eINSTANCE.createValue();
            varInitialization.setValue(initialValue.getNodeValue());
            v.setValue(varInitialization);
        }
        if ((comment = map.getNamedItem("Comment")) != null) {
            v.setComment(comment.getNodeValue());
        }
        return v;
    }

    public static Event parseEvent(Node n) throws TypeImportException {
        NamedNodeMap map = n.getAttributes();
        Event e = LibraryElementFactory.eINSTANCE.createEvent();
        e.setType(EventTypeLibrary.getInstance().getType(null));
        Node name = map.getNamedItem("Name");
        if (name == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_InputEventNameNotDefined);
        }
        e.setName(name.getNodeValue());
        Node comment = map.getNamedItem("Comment");
        if (comment != null) {
            e.setComment(comment.getNodeValue());
        }
        return e;
    }

    public static AdapterEvent createAdapterEvent(Event event, AdapterDeclaration a) {
        AdapterEvent ae = LibraryElementFactory.eINSTANCE.createAdapterEvent();
        ae.setName(event.getName());
        ae.setComment(event.getComment());
        ae.setAdapterDeclaration(a);
        return ae;
    }

    public static String getSeperatorRegex() {
        String regex = File.separator;
        if (regex.equals("\\")) {
            regex = "\\\\";
        }
        return regex;
    }

    public static void copyFile(File in, File out) throws IOException {
        Files.copy(in.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File in, IFile out) throws IOException, CoreException {
        if (!out.getParent().exists()) {
            ((IFolder)out.getParent()).create(true, true, null);
            out.getParent().refreshLocal(0, null);
        }
        Files.copy(in.toPath(), out.getLocation().toFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        try {
            out.getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }
}

