/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.Arrays;
import java.util.List;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInterfaceOrderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeSubAppIENameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTypeCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.CustomTextCellEditor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractEditInterfaceSection
extends AbstractSection {
    private static final int TYPE_AND_COMMENT_COLUMN_WIDTH = 100;
    private static final int NAME_COLUMN_WIDTH = 200;
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String COMMENT = "comment";
    private TableViewer inputsViewer;
    private TableViewer outputsViewer;

    protected abstract CreateInterfaceElementCommand newCreateCommand(boolean var1);

    protected abstract DeleteInterfaceCommand newDeleteCommand(IInterfaceElement var1);

    protected abstract ChangeInterfaceOrderCommand newOrderCommand(IInterfaceElement var1, boolean var2, boolean var3);

    protected abstract String[] fillTypeCombo();

    protected abstract INamedElement getInputType(Object var1);

    protected ChangeTypeCommand newChangeTypeCommand(VarDeclaration data, DataType newType) {
        return new ChangeTypeCommand(data, newType);
    }

    public TableViewer getInputsViewer() {
        return this.inputsViewer;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createInputEdit(parent);
        this.createOutputEdit(parent);
        this.inputsViewer.setContentProvider(this.getInputsContentProvider());
        this.outputsViewer.setContentProvider(this.getOutputsContentProvider());
    }

    protected abstract IContentProvider getOutputsContentProvider();

    protected abstract IContentProvider getInputsContentProvider();

    private static void createTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(NAME);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(TYPE);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(COMMENT);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        table.setLayout((Layout)layout);
    }

    private void createInputEdit(Composite parent) {
        Group inputsGroup = this.getWidgetFactory().createGroup(parent, "Inputs");
        inputsGroup.setLayout((Layout)new GridLayout(2, false));
        inputsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
        buttons.createControls((Composite)inputsGroup, this.getWidgetFactory());
        this.inputsViewer = this.createTypeTableView(inputsGroup);
        this.configureButtonList(buttons, this.inputsViewer, true);
    }

    private TableViewer createTypeTableView(Group parent) {
        TableViewer viewer = TableWidgetFactory.createTableViewer((Composite)parent);
        AbstractEditInterfaceSection.createTableLayout(viewer.getTable());
        viewer.setColumnProperties(new String[]{NAME, TYPE, COMMENT});
        viewer.setCellModifier((ICellModifier)new InterfaceCellModifier(viewer));
        viewer.setLabelProvider((IBaseLabelProvider)new InterfaceLabelProvider());
        return viewer;
    }

    private void configureButtonList(AddDeleteReorderListWidget buttons, TableViewer viewer, boolean inputs) {
        buttons.bindToTableViewer(viewer, (CommandExecutor)this, ref -> this.newCreateCommand(inputs), ref -> this.newDeleteCommand((IInterfaceElement)ref), ref -> this.newOrderCommand((IInterfaceElement)ref, inputs, true), ref -> this.newOrderCommand((IInterfaceElement)ref, inputs, false));
    }

    private void setCellEditors(TableViewer viewer) {
        viewer.setCellEditors(new CellEditor[]{new CustomTextCellEditor((Composite)viewer.getTable()), ComboBoxWidgetFactory.createComboBoxCellEditor((Composite)viewer.getTable(), (String[])this.fillTypeCombo(), (int)8), new CustomTextCellEditor((Composite)viewer.getTable())});
    }

    private void createOutputEdit(Composite parent) {
        Group outputsGroup = this.getWidgetFactory().createGroup(parent, "Outputs");
        outputsGroup.setLayout((Layout)new GridLayout(2, false));
        outputsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
        buttons.createControls((Composite)outputsGroup, this.getWidgetFactory());
        this.outputsViewer = this.createTypeTableView(outputsGroup);
        this.configureButtonList(buttons, this.outputsViewer, false);
    }

    @Override
    protected void setInputCode() {
    }

    @Override
    protected void setInputInit() {
        this.setCellEditors(this.inputsViewer);
        this.setCellEditors(this.outputsViewer);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.inputsViewer.setInput((Object)this.getType());
            this.outputsViewer.setInput((Object)this.getType());
        }
        this.commandStack = commandStackBuffer;
    }

    protected Palette getPalette() {
        if (this.getType() instanceof SubApp) {
            return ((SubApp)this.getType()).getFbNetwork().getApplication().getAutomationSystem().getPalette();
        }
        if (this.getType() instanceof FBType) {
            return ((FBType)this.getType()).getPaletteEntry().getGroup().getPallete();
        }
        return null;
    }

    private class InterfaceCellModifier
    implements ICellModifier {
        private static final int TYPE_COLUMN_INDEX = 1;
        private TableViewer viewer;

        public InterfaceCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return !AbstractEditInterfaceSection.TYPE.equals(property) || !(element instanceof IInterfaceElement) || ((IInterfaceElement)element).getInputConnections().isEmpty() && ((IInterfaceElement)element).getOutputConnections().isEmpty();
        }

        public Object getValue(Object element, String property) {
            switch (property) {
                case "name": {
                    return ((INamedElement)element).getName();
                }
                case "type": {
                    String type = ((IInterfaceElement)element).getTypeName();
                    List<String> items = Arrays.asList(((ComboBoxCellEditor)this.viewer.getCellEditors()[1]).getItems());
                    return items.indexOf(type);
                }
                case "comment": {
                    return ((INamedElement)element).getComment() != null ? ((INamedElement)element).getComment() : "";
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            Object data = tableItem.getData();
            ChangeSubAppIENameCommand cmd = null;
            switch (property) {
                case "name": {
                    cmd = new ChangeSubAppIENameCommand((IInterfaceElement)data, value.toString());
                    break;
                }
                case "comment": {
                    cmd = new ChangeCommentCommand((INamedElement)data, value.toString());
                    break;
                }
                case "type": {
                    String dataTypeName = ((ComboBoxCellEditor)this.viewer.getCellEditors()[1]).getItems()[(Integer)value];
                    if (data instanceof AdapterDeclaration) {
                        AdapterType newType = AbstractEditInterfaceSection.this.getPalette().getAdapterTypeEntry(dataTypeName).getType();
                        cmd = AbstractEditInterfaceSection.this.newChangeTypeCommand((VarDeclaration)data, (DataType)newType);
                        break;
                    }
                    if (!(data instanceof VarDeclaration)) break;
                    cmd = AbstractEditInterfaceSection.this.newChangeTypeCommand((VarDeclaration)data, DataTypeLibrary.getInstance().getType(dataTypeName));
                    break;
                }
            }
            if (cmd != null) {
                AbstractEditInterfaceSection.this.executeCommand((Command)cmd);
                this.viewer.refresh(data);
            }
        }
    }

    protected static class InterfaceContentProvider
    implements IStructuredContentProvider {
        private boolean inputs;
        private InterfaceContentProviderType type;

        public InterfaceContentProvider(boolean inputs, InterfaceContentProviderType type) {
            this.inputs = inputs;
            this.type = type;
        }

        private Object[] getInputs(Object inputElement) {
            InterfaceList interfaceList = InterfaceContentProvider.getInterfaceListFromInput(inputElement);
            if (interfaceList != null) {
                switch (this.type) {
                    case EVENT: {
                        return interfaceList.getEventInputs().toArray();
                    }
                    case ADAPTER: {
                        return interfaceList.getSockets().toArray();
                    }
                    case DATA: {
                        return interfaceList.getInputVars().toArray();
                    }
                }
            }
            return new Object[0];
        }

        private Object[] getOutputs(Object inputElement) {
            InterfaceList interfaceList = InterfaceContentProvider.getInterfaceListFromInput(inputElement);
            if (interfaceList != null) {
                switch (this.type) {
                    case EVENT: {
                        return interfaceList.getEventOutputs().toArray();
                    }
                    case ADAPTER: {
                        return interfaceList.getPlugs().toArray();
                    }
                    case DATA: {
                        return interfaceList.getOutputVars().toArray();
                    }
                }
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof SubApp || inputElement instanceof FBType) {
                if (this.inputs) {
                    return this.getInputs(inputElement);
                }
                return this.getOutputs(inputElement);
            }
            return new Object[0];
        }

        private static InterfaceList getInterfaceListFromInput(Object inputElement) {
            InterfaceList interfaceList = null;
            if (inputElement instanceof SubApp) {
                interfaceList = ((SubApp)inputElement).getInterface();
            } else if (inputElement instanceof FBType) {
                interfaceList = ((FBType)inputElement).getInterfaceList();
            }
            return interfaceList;
        }
    }

    protected static enum InterfaceContentProviderType {
        EVENT,
        DATA,
        ADAPTER;

    }

    protected static class InterfaceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected InterfaceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof IInterfaceElement) {
                switch (columnIndex) {
                    case 0: {
                        result = ((IInterfaceElement)element).getName();
                        break;
                    }
                    case 1: {
                        result = element instanceof Event ? "Event" : ((IInterfaceElement)element).getTypeName();
                        break;
                    }
                    case 2: {
                        result = ((IInterfaceElement)element).getComment() != null ? ((IInterfaceElement)element).getComment() : "";
                    }
                }
            } else {
                result = element.toString();
            }
            return result;
        }
    }
}

