/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.impl.dom.CSSComputedStyleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.StyleWrapper;
import org.eclipse.e4.ui.css.core.impl.sac.ExtendedSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.views.DocumentView;

public class ViewCSSImpl
implements ViewCSS,
ExtendedDocumentCSS.StyleSheetChangeListener {
    protected DocumentCSS documentCSS;
    private boolean ruleCachingEnabled;
    private List<CSSRule> currentCombinedRules;

    public ViewCSSImpl(DocumentCSS documentCSS) {
        this.documentCSS = documentCSS;
        if (this.documentCSS instanceof ExtendedDocumentCSS) {
            ((ExtendedDocumentCSS)this.documentCSS).addStyleSheetChangeListener(this);
            this.ruleCachingEnabled = true;
        }
    }

    @Override
    public DocumentView getDocument() {
        return null;
    }

    @Override
    public CSSStyleDeclaration getComputedStyle(Element elt, String pseudoElt) {
        return this.getComputedStyle(this.getCombinedRules(), elt, pseudoElt);
    }

    private List<CSSRule> getCombinedRules() {
        if (this.ruleCachingEnabled && this.currentCombinedRules != null) {
            return this.currentCombinedRules;
        }
        StyleSheetList styleSheetList = this.documentCSS.getStyleSheets();
        int l = styleSheetList.getLength();
        ArrayList<CSSRule> cssRules = new ArrayList<CSSRule>();
        int i = 0;
        while (i < l) {
            CSSStyleSheet styleSheet = (CSSStyleSheet)styleSheetList.item(i);
            CSSRuleList styleSheetRules = styleSheet.getCssRules();
            int rulesSize = styleSheetRules.getLength();
            int j = 0;
            while (j < rulesSize) {
                cssRules.add(styleSheetRules.item(j));
                ++j;
            }
            ++i;
        }
        if (this.ruleCachingEnabled) {
            this.currentCombinedRules = cssRules;
        }
        return cssRules;
    }

    public CSSStyleDeclaration getComputedStyle(List<CSSRule> ruleList, Element elt, String pseudoElt) {
        ArrayList<StyleWrapper> styleDeclarations = null;
        StyleWrapper firstStyleDeclaration = null;
        int length = ruleList.size();
        int position = 0;
        int i = 0;
        while (i < length) {
            CSSRule rule = ruleList.get(i);
            if (rule.getType() == 1) {
                CSSStyleRule styleRule = (CSSStyleRule)rule;
                if (rule instanceof ExtendedCSSRule) {
                    ExtendedCSSRule r = (ExtendedCSSRule)rule;
                    SelectorList selectorList = r.getSelectorList();
                    int l = selectorList.getLength();
                    int j = 0;
                    while (j < l) {
                        ExtendedSelector extendedSelector;
                        Selector selector = selectorList.item(j);
                        if (selector instanceof ExtendedSelector && (extendedSelector = (ExtendedSelector)selector).match(elt, pseudoElt)) {
                            CSSStyleDeclaration style = styleRule.getStyle();
                            int specificity = extendedSelector.getSpecificity();
                            StyleWrapper wrapper = new StyleWrapper(style, specificity, position++);
                            if (firstStyleDeclaration == null) {
                                firstStyleDeclaration = wrapper;
                            } else {
                                if (styleDeclarations == null) {
                                    styleDeclarations = new ArrayList<StyleWrapper>();
                                    styleDeclarations.add(firstStyleDeclaration);
                                }
                                styleDeclarations.add(wrapper);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (styleDeclarations != null) {
            return new CSSComputedStyleImpl(styleDeclarations);
        }
        if (firstStyleDeclaration != null) {
            return firstStyleDeclaration.style;
        }
        return null;
    }

    @Override
    public void styleSheetAdded(StyleSheet styleSheet) {
        this.currentCombinedRules = null;
    }

    @Override
    public void styleSheetRemoved(StyleSheet styleSheet) {
        this.currentCombinedRules = null;
    }
}

