/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.handlers;

import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.ui.handlers.AbstractDeploymentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.ResourceEditPart;

public class DeleteResourceHandler
extends AbstractDeploymentCommand {
    private Resource resource;

    @Override
    protected boolean prepareParametersToExecute(Object element) {
        this.setDevice(null);
        if (element instanceof Resource) {
            this.resource = (Resource)element;
            this.setDevice(this.resource.getDevice());
            if (this.getDevice() != null) {
                return true;
            }
        } else if (element instanceof ResourceEditPart) {
            this.resource = ((ResourceEditPart)element).getModel();
            this.setDevice(this.resource.getDevice());
            if (this.getDevice() != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void executeCommand(IDeviceManagementInteractor executor) throws DeploymentException {
        executor.deleteResource(this.resource.getName());
    }

    @Override
    protected void manageExecutorError() {
        DeploymentCoordinator.printUnsupportedDeviceProfileMessageBox((Device)this.getDevice(), (Resource)this.resource);
    }

    @Override
    protected String getErrorMessageHeader() {
        return "Delete Resource Error";
    }

    @Override
    protected String getCurrentElementName() {
        return "Resource: " + this.resource.getName();
    }
}

