/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class WatchesContentProvider
implements ITreeContentProvider {
    private Viewer viewer;
    private Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            int featureID = notification.getFeatureID(MonitoringElement.class);
            if (featureID == 4 && notification.getNotifier() instanceof MonitoringElement) {
                Display.getDefault().asyncExec(() -> {
                    if (!WatchesContentProvider.this.viewer.getControl().isDisposed()) {
                        ((TreeViewer)WatchesContentProvider.this.viewer).refresh(notification.getNotifier());
                    }
                });
            }
        }
    };
    private List<MonitoringBaseElement> watchedElements = new ArrayList<MonitoringBaseElement>();

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof MonitoringElement) {
            return new Object[0];
        }
        this.removeAdapterFromChildrenList();
        this.watchedElements.clear();
        for (MonitoringBaseElement element : MonitoringManager.getInstance().getElementsToMonitor()) {
            if (element == null || this.watchedElements.contains(element)) continue;
            element.eAdapters().add((Object)this.adapter);
            this.watchedElements.add(element);
        }
        return this.watchedElements.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.removeAdapterFromChildrenList();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    private void removeAdapterFromChildrenList() {
        for (MonitoringBaseElement element : this.watchedElements) {
            if (!element.eAdapters().contains((Object)this.adapter)) continue;
            element.eAdapters().remove((Object)this.adapter);
        }
    }
}

