/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.gef.commands.Command;

public class CreateServiceSequenceCommand
extends Command {
    private FBType fbType;
    private String name;
    private String leftInterfaceName;
    private String rightInterfaceName;
    private ServiceInterface leftInterface;
    private ServiceInterface rightInterface;
    private ServiceSequence sq;

    public CreateServiceSequenceCommand(FBType fbType) {
        this.fbType = fbType;
        this.name = "Service Sequence";
        this.leftInterfaceName = "left interface";
        this.rightInterfaceName = "right interface";
    }

    public boolean canExecute() {
        return this.fbType != null;
    }

    public void execute() {
        if (this.fbType.getService() == null) {
            this.fbType.setService(LibraryElementFactory.eINSTANCE.createService());
        }
        this.sq = LibraryElementFactory.eINSTANCE.createServiceSequence();
        this.sq.setName(this.name);
        if (this.fbType.getService().getLeftInterface() == null) {
            this.leftInterface = LibraryElementFactory.eINSTANCE.createServiceInterface();
            this.leftInterface.setName(this.leftInterfaceName);
            this.fbType.getService().setLeftInterface(this.leftInterface);
        }
        if (this.fbType.getService().getRightInterface() == null) {
            this.rightInterface = LibraryElementFactory.eINSTANCE.createServiceInterface();
            this.rightInterface.setName(this.rightInterfaceName);
            this.fbType.getService().setRightInterface(this.rightInterface);
        }
        this.fbType.getService().getServiceSequence().add((Object)this.sq);
    }

    public void undo() {
        if (this.leftInterface != null) {
            this.fbType.getService().setLeftInterface(null);
        }
        if (this.rightInterface != null) {
            this.fbType.getService().setRightInterface(null);
        }
        this.fbType.getService().getServiceSequence().remove((Object)this.sq);
    }

    public void redo() {
        if (this.leftInterface != null) {
            this.fbType.getService().setLeftInterface(this.leftInterface);
        }
        if (this.rightInterface != null) {
            this.fbType.getService().setRightInterface(this.rightInterface);
        }
        this.fbType.getService().getServiceSequence().add((Object)this.sq);
    }
}

