/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.InputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.OutputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies.DeleteTransactionEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies.TransactionLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.draw2d.AdvancedLineBorder;
import org.eclipse.fordiac.ide.gef.policies.HighlightEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class TransactionEditPart
extends AbstractGraphicalEditPart {
    private Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (TransactionEditPart.this.getCastedModel().eAdapters().contains((Object)TransactionEditPart.this.adapter)) {
                TransactionEditPart.this.refresh();
            }
        }
    };

    public void activate() {
        if (!this.isActive()) {
            this.getCastedModel().eAdapters().add((Object)this.adapter);
        }
        super.activate();
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getCastedModel().eAdapters().remove((Object)this.adapter);
        }
        super.deactivate();
    }

    protected IFigure createFigure() {
        return new TransactionFigure();
    }

    public ServiceTransaction getCastedModel() {
        return (ServiceTransaction)this.getModel();
    }

    public OutputPrimitive getPossibleOutputPrimitive(InputPrimitive inputPrimitive) {
        try {
            int index = this.getModelChildren().indexOf(inputPrimitive);
            if (this.getModelChildren().get(index + 1) instanceof OutputPrimitive) {
                return (OutputPrimitive)this.getModelChildren().get(index + 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        return null;
    }

    public InputPrimitive getPossibleInputPrimitive(Primitive outputPrimitive) {
        try {
            int index = this.getModelChildren().indexOf(outputPrimitive);
            if (this.getModelChildren().get(index - 1) instanceof InputPrimitive) {
                return (InputPrimitive)this.getModelChildren().get(index - 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        return null;
    }

    protected List<?> getModelChildren() {
        ServiceTransaction transaction = this.getCastedModel();
        ArrayList<InputPrimitive> children = new ArrayList<InputPrimitive>();
        if (transaction.getInputPrimitive() != null) {
            children.add(transaction.getInputPrimitive());
        }
        if (!transaction.getOutputPrimitive().isEmpty()) {
            children.addAll((Collection<InputPrimitive>)transaction.getOutputPrimitive());
        }
        return children;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof InputPrimitiveEditPart || childEditPart instanceof OutputPrimitiveEditPart) {
            TransactionFigure thisFigure = (TransactionFigure)this.getFigure();
            IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
            GridData childData = new GridData();
            childData.grabExcessHorizontalSpace = true;
            childData.horizontalAlignment = 4;
            thisFigure.getLayoutManager().setConstraint(child, (Object)childData);
            thisFigure.add(child, childEditPart instanceof InputPrimitiveEditPart ? 0 : index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof InputPrimitiveEditPart || childEditPart instanceof OutputPrimitiveEditPart) {
            IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
            ((TransactionFigure)this.getFigure()).remove(child);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TransactionLayoutEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new HighlightEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteTransactionEditPolicy());
    }

    public static class TransactionFigure
    extends Figure {
        public TransactionFigure() {
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            this.setBorder((Border)new AdvancedLineBorder(1, 2));
            this.setLayoutManager((LayoutManager)layout);
        }
    }
}

