/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.structuredtext.validation;

import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.AdapterVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.LocatedVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.PartialAccess;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.PrimaryVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StructuredTextPackage;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Variable;
import org.eclipse.fordiac.ide.model.structuredtext.validation.AbstractStructuredTextValidator;
import org.eclipse.xtext.validation.Check;

public class StructuredTextValidator
extends AbstractStructuredTextValidator {
    private int AccessBits(PartialAccess part) {
        return this.BitSize(this.extractTypeInformation(part, ""));
    }

    private boolean isIndexInRange(PartialAccess p, int size) {
        return p.getIndex() >= 0 && p.getIndex() < size;
    }

    @Check
    public void checkPartialAccess(PrimaryVariable v) {
        boolean _tripleNotEquals;
        PartialAccess _part = v.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            int _BitSize = this.BitSize(v.getVar().getType().getName());
            int _AccessBits = this.AccessBits(v.getPart());
            int indexSize = _BitSize / _AccessBits;
            if (this.AccessBits(v.getPart()) > 0 && this.BitSize(v.getVar().getType().getName()) > this.AccessBits(v.getPart())) {
                boolean _not;
                boolean _isIndexInRange = this.isIndexInRange(v.getPart(), indexSize);
                boolean bl2 = _not = !_isIndexInRange;
                if (_not) {
                    this.error("Incorrect partial access: index not within limits.", (EStructuralFeature)StructuredTextPackage.Literals.PRIMARY_VARIABLE__VAR);
                } else if (this.AccessBits(v.getPart()) == 0 || this.BitSize(v.getVar().getType().getName()) == 0) {
                    this.error("Incorrect partial access: datatypes other than ANY_BIT.", (EStructuralFeature)StructuredTextPackage.Literals.PRIMARY_VARIABLE__VAR);
                } else if (indexSize < 1) {
                    this.error("Incorrect partial access: access dataype must be smaller than storage datatype.", (EStructuralFeature)StructuredTextPackage.Literals.PRIMARY_VARIABLE__VAR);
                }
            }
        }
    }

    private int _BitSize(VarDeclaration v) {
        return this.BitSize(this.extractTypeInformation((EObject)v));
    }

    private int _BitSize(PrimaryVariable v) {
        return this.BitSize(this.extractTypeInformation(v));
    }

    private int _BitSize(LocatedVariable v) {
        return this.BitSize(this.extractTypeInformation((EObject)v));
    }

    private int _BitSize(String str) {
        boolean _equals_4;
        boolean _equals_3;
        boolean _equals_2;
        boolean _equals_1;
        int _switchResult = 0;
        boolean _matched = false;
        boolean _equals = str.equals("LWORD");
        if (_equals) {
            _matched = true;
            _switchResult = 64;
        }
        if (!_matched && (_equals_1 = str.equals("DWORD"))) {
            _matched = true;
            _switchResult = 32;
        }
        if (!_matched && (_equals_2 = str.equals("WORD"))) {
            _matched = true;
            _switchResult = 16;
        }
        if (!_matched && (_equals_3 = str.equals("BYTE"))) {
            _matched = true;
            _switchResult = 8;
        }
        if (!_matched && (_equals_4 = str.equals("BOOL"))) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched) {
            _switchResult = 0;
        }
        return _switchResult;
    }

    private String _extractTypeInformation(PartialAccess part, String DataType2) {
        String _xifexpression = null;
        if (part != null) {
            String _xifexpression_1 = null;
            boolean _isBitaccess = part.isBitaccess();
            if (_isBitaccess) {
                _xifexpression_1 = "BOOL";
            } else {
                String _xifexpression_2 = null;
                boolean _isByteaccess = part.isByteaccess();
                if (_isByteaccess) {
                    _xifexpression_2 = "BYTE";
                } else {
                    String _xifexpression_3 = null;
                    boolean _isWordaccess = part.isWordaccess();
                    if (_isWordaccess) {
                        _xifexpression_3 = "WORD";
                    } else {
                        String _xifexpression_4 = null;
                        boolean _isDwordaccess = part.isDwordaccess();
                        _xifexpression_4 = _isDwordaccess ? "DWORD" : "";
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = DataType2;
        }
        return _xifexpression;
    }

    private String _extractTypeInformation(PrimaryVariable variable, String DataType2) {
        String _xifexpression = null;
        _xifexpression = variable != null && variable.getPart() != null ? this.extractTypeInformation(variable.getPart()) : variable.getVar().getType().getName();
        return _xifexpression;
    }

    private String _extractTypeInformation(Variable variable, String DataType2) {
        String _xifexpression = null;
        _xifexpression = variable != null && variable.getPart() != null ? this.extractTypeInformation(variable.getPart()) : "";
        return _xifexpression;
    }

    protected String _extractTypeInformation(PrimaryVariable variable) {
        String _xifexpression = null;
        _xifexpression = variable != null ? this.extractTypeInformation(variable, this.extractTypeInformation((EObject)variable.getVar())) : variable.getVar().getType().getName();
        return _xifexpression;
    }

    protected String _extractTypeInformation(VarDeclaration variable) {
        return variable.getType().getName();
    }

    protected String _extractTypeInformation(AdapterVariable variable) {
        return variable.getVar().getType().getName();
    }

    @Check
    public void checkAtLocation(LocatedVariable v) {
        boolean _tripleNotEquals;
        Variable _location = v.getLocation();
        boolean bl = _tripleNotEquals = _location != null;
        if (_tripleNotEquals) {
            if (this.BitSize(v) == 0 && v.isArray()) {
                this.error("Piecewise located variables are allowed only for variables of type ANY_BIT", (EStructuralFeature)StructuredTextPackage.Literals.LOCATED_VARIABLE__LOCATION);
            }
            if (this.BitSize(v) > 0 && v.isArray() && v.getArraySize() == 0) {
                this.error("Piecewise located variables must have at least an array size of 1", (EStructuralFeature)StructuredTextPackage.Literals.LOCATED_VARIABLE__LOCATION);
            }
            if (this.BitSize(v) > 0 && v.isArray() && v.getArraySize() > this.BitSize(v.getLocation())) {
                this.error("Piecewise located variables cannot access more bits than are available in the destination", (EStructuralFeature)StructuredTextPackage.Literals.LOCATED_VARIABLE__LOCATION);
            }
            if (this.BitSize(v) == 0 && this.BitSize(v.getLocation()) == 0 && !Objects.equal((Object)this.extractTypeInformation(v.getLocation(), this.extractTypeInformation(v.getLocation())), (Object)this.extractTypeInformation((EObject)v))) {
                this.error("General located variables must have matching types", (EStructuralFeature)StructuredTextPackage.Literals.LOCATED_VARIABLE__LOCATION);
            }
        }
    }

    private int BitSize(Object v) {
        if (v instanceof LocatedVariable) {
            return this._BitSize((LocatedVariable)v);
        }
        if (v instanceof VarDeclaration) {
            return this._BitSize((VarDeclaration)v);
        }
        if (v instanceof PrimaryVariable) {
            return this._BitSize((PrimaryVariable)v);
        }
        if (v instanceof String) {
            return this._BitSize((String)v);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(v).toString());
    }

    private String extractTypeInformation(EObject variable, String DataType2) {
        if (variable instanceof PrimaryVariable) {
            return this._extractTypeInformation((PrimaryVariable)variable, DataType2);
        }
        if (variable instanceof Variable) {
            return this._extractTypeInformation((Variable)variable, DataType2);
        }
        if (variable instanceof PartialAccess) {
            return this._extractTypeInformation((PartialAccess)variable, DataType2);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(variable, DataType2).toString());
    }

    protected String extractTypeInformation(EObject variable) {
        if (variable instanceof VarDeclaration) {
            return this._extractTypeInformation((VarDeclaration)variable);
        }
        if (variable instanceof AdapterVariable) {
            return this._extractTypeInformation((AdapterVariable)variable);
        }
        if (variable instanceof PrimaryVariable) {
            return this._extractTypeInformation((PrimaryVariable)variable);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(variable).toString());
    }
}

