/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.editparts.NameCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.TextDirectEditManager;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Text;

public class LabelDirectEditManager
extends TextDirectEditManager {
    private Label label;
    private Font scaledFont;
    private String initialString = null;
    private VerifyListener aditionalVerify = null;

    public LabelDirectEditManager(GraphicalEditPart source, Label label) {
        this(source, label, null);
    }

    public LabelDirectEditManager(GraphicalEditPart source, Label label, VerifyListener aditionalVerifyListener) {
        super(source, TextCellEditor.class, new NameCellEditorLocator(label));
        this.label = label;
        this.aditionalVerify = aditionalVerifyListener;
    }

    public void show(char initialChar) {
        this.initialString = new String(new char[]{initialChar});
        this.show();
        Text textControl = (Text)this.getCellEditor().getControl();
        textControl.setSelection(1);
        this.setDirty(true);
        this.getLocator().relocate(this.getCellEditor());
    }

    @Override
    protected void bringDown() {
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        this.initialString = null;
        this.getLocator().relocate(this.getCellEditor());
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    @Override
    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        if (this.aditionalVerify != null) {
            text.addVerifyListener(this.aditionalVerify);
        }
        String initialLabelText = "";
        if (this.initialString == null) {
            initialLabelText = this.label.getText();
            this.getCellEditor().setValue((Object)initialLabelText);
        } else {
            initialLabelText = this.initialString;
            this.getCellEditor().setValue((Object)initialLabelText);
        }
        IFigure figure = this.getEditPart().getFigure();
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.label.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.scaledFont = new Font(null, data);
        text.setFont(this.scaledFont);
        text.selectAll();
    }

    public void setInitialString(String val) {
        this.initialString = val;
        if (this.getCellEditor() != null) {
            this.getCellEditor().setValue((Object)this.initialString);
        }
    }

    protected void unhookListeners() {
        super.unhookListeners();
        try {
            Text text = (Text)this.getCellEditor().getControl();
            if (this.aditionalVerify != null) {
                text.removeVerifyListener(this.aditionalVerify);
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }
}

