/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.preferences;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.router.IConnectionRouterFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DiagramPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CONNECTION_ROUTER = "ConnectionRouter";
    public static final String SELECTION_COLOR = "SelectionColor";
    public static final int CORNER_DIM = 14;
    public static final int CORNER_DIM_HALF = 7;
    public static final String GRID_SPACING = "GridSpacing";
    public static final String SNAP_TO_GRID = "SnapToGrid";
    public static final String SHOW_GRID = "ShowGrid";
    public static final String SHOW_RULERS = "ShowRulers";
    public static final String MAX_VALUE_LABEL_SIZE = "MaxValueLabelSize";

    public DiagramPreferences() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.DiagramPreferences_GeneralDiagramPreferences);
    }

    public void createFieldEditors() {
        this.createGroupRulerGrid();
        this.createGroupRouter();
        this.createGroupColor();
        this.createGroupLabelSize();
    }

    private Group createGroup(String title) {
        Group group = new Group(this.getFieldEditorParent(), 0);
        group.setText(title);
        return group;
    }

    private void configGroup(Group group) {
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
    }

    private void createGroupLabelSize() {
        Group labelSize = this.createGroup(Messages.DiagramPreferences_LabelSize);
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(MAX_VALUE_LABEL_SIZE, Messages.DiagramPreferences_MaximumValueLabelSize, (Composite)labelSize);
        integerFieldEditor.setValidRange(0, 120);
        this.addField((FieldEditor)integerFieldEditor);
        this.configGroup(labelSize);
    }

    private void createGroupColor() {
        Group color = this.createGroup(Messages.DiagramPreferences_Colors);
        ColorFieldEditor selectionBorderColor = new ColorFieldEditor(SELECTION_COLOR, Messages.DiagramPreferences_SelectionColor, (Composite)color);
        this.addField((FieldEditor)selectionBorderColor);
        this.configGroup(color);
    }

    private void createGroupRulerGrid() {
        Group group = this.createGroup(Messages.DiagramPreferences_FieldEditors_RulerAndGrid);
        BooleanFieldEditor showRulers = new BooleanFieldEditor(SHOW_RULERS, Messages.DiagramPreferences_FieldEditors_ShowRuler, (Composite)group);
        this.addField((FieldEditor)showRulers);
        BooleanFieldEditor showGrid = new BooleanFieldEditor(SHOW_GRID, Messages.DiagramPreferences_FieldEditors_ShowGrid, (Composite)group);
        this.addField((FieldEditor)showGrid);
        BooleanFieldEditor snapToGrid = new BooleanFieldEditor(SNAP_TO_GRID, Messages.DiagramPreferences_FieldEditors_SnapToGrid, (Composite)group);
        this.addField((FieldEditor)snapToGrid);
        IntegerFieldEditor gridSpacing = new IntegerFieldEditor(GRID_SPACING, Messages.DiagramPreferences_FieldEditors_GridSpacingInPixels, (Composite)group);
        gridSpacing.setTextLimit(10);
        this.addField((FieldEditor)gridSpacing);
        this.configGroup(group);
    }

    private void createGroupRouter() {
        Group router = this.createGroup(Messages.DiagramPreferences_ConnectionRouter);
        HashMap<String, IConnectionRouterFactory> connectionRouter = new HashMap<String, IConnectionRouterFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.gef", "ConnectionRouterProvider");
        int i = 0;
        while (i < elems.length) {
            IConfigurationElement element = elems[i];
            try {
                Object object = element.createExecutableExtension("class");
                String name = element.getAttribute("name");
                if (object instanceof IConnectionRouterFactory) {
                    IConnectionRouterFactory routerFactory = (IConnectionRouterFactory)object;
                    connectionRouter.put(name, routerFactory);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError("Error loading ConnectionRouter", (Exception)((Object)corex));
            }
            ++i;
        }
        Set keySet = connectionRouter.keySet();
        String[][] nameArray = new String[keySet.size()][2];
        int i2 = 0;
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String key;
            nameArray[i2][0] = key = (String)iterator.next();
            nameArray[i2][1] = key;
            ++i2;
        }
        ComboFieldEditor routerEditor = new ComboFieldEditor(CONNECTION_ROUTER, Messages.DiagramPreferences_DefaultRouter, nameArray, (Composite)router);
        this.addField((FieldEditor)routerEditor);
        this.configGroup(router);
    }

    public void init(IWorkbench workbench) {
    }
}

