/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.libraryElement.provider.LibraryElementItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractSection
extends AbstractPropertySection
implements CommandExecutor {
    protected Object type;
    protected CommandStack commandStack;
    private Composite rightComposite;
    private Composite leftComposite;
    protected boolean createSuperControls = true;
    private ComposedAdapterFactory adapterFactory;
    protected boolean blockRefresh = false;
    private final Adapter contentAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (AbstractSection.this.getType() != null && AbstractSection.this.getType().eAdapters().contains((Object)AbstractSection.this.contentAdapter) && !AbstractSection.this.blockRefresh) {
                AbstractSection.this.leftComposite.getDisplay().asyncExec(() -> {
                    if (!AbstractSection.this.leftComposite.isDisposed()) {
                        AbstractSection.this.refresh();
                    }
                });
            }
        }
    };

    protected abstract EObject getType();

    protected abstract Object getInputType(Object var1);

    protected abstract void setInputCode();

    protected abstract void setInputInit();

    protected void setType(Object input) {
        this.type = this.getInputType(input);
        this.addContentAdapter();
    }

    protected CommandStack getCommandStack(IWorkbenchPart part, Object input) {
        return (CommandStack)part.getAdapter(CommandStack.class);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.commandStack = this.getCommandStack(part, input);
        if (this.commandStack == null) {
            this.setInputCode();
        }
        this.setType(input);
        this.setInputInit();
    }

    public void dispose() {
        this.removeContentAdapter();
        super.dispose();
    }

    protected void removeContentAdapter() {
        if (this.getType() != null && this.getType().eAdapters().contains((Object)this.contentAdapter)) {
            this.getType().eAdapters().remove((Object)this.contentAdapter);
        }
    }

    protected void addContentAdapter() {
        if (this.getType() != null && !this.getType().eAdapters().contains((Object)this.contentAdapter)) {
            this.getType().eAdapters().add((Object)this.contentAdapter);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        if (this.createSuperControls) {
            parent.setLayout((Layout)new GridLayout(2, true));
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
            this.leftComposite = this.getWidgetFactory().createComposite(parent);
            this.leftComposite.setLayout((Layout)new GridLayout());
            this.leftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.rightComposite = this.getWidgetFactory().createComposite(parent);
            this.rightComposite.setLayout((Layout)new GridLayout());
            this.rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        } else {
            this.leftComposite = parent;
            parent.setLayout((Layout)new GridLayout(1, true));
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
        }
    }

    public void executeCommand(Command cmd) {
        if (this.type != null && this.commandStack != null && cmd.canExecute()) {
            this.blockRefresh = true;
            this.commandStack.execute(cmd);
            this.blockRefresh = false;
        }
    }

    protected Text createGroupText(Composite group, boolean editable) {
        Text text = this.getWidgetFactory().createText(group, "", 2048);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        text.setEditable(editable);
        text.setEnabled(editable);
        return text;
    }

    protected ComposedAdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new LibraryElementItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new DataItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        }
        return this.adapterFactory;
    }

    protected Composite getLeftComposite() {
        return this.leftComposite;
    }

    protected void setLeftComposite(Composite leftComposite) {
        this.leftComposite = leftComposite;
    }

    protected Composite getRightComposite() {
        return this.rightComposite;
    }

    protected void setRightComposite(Composite rightComposite) {
        this.rightComposite = rightComposite;
    }
}

