/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.ui.providers.AbstractCreationCommand;

public class CreateAlgorithmCommand
extends AbstractCreationCommand {
    private static final String DEFAULT_ALGORITHM_NAME = "ALG1";
    private final BasicFBType fbType;
    private STAlgorithm newAlgorithm;
    private Algorithm oldAlgorithm;
    private ECAction action;
    private int index;
    private String name;

    public CreateAlgorithmCommand(BasicFBType fbType) {
        this(fbType, fbType.getAlgorithm().size() - 1, null);
    }

    public Algorithm getNewAlgorithm() {
        return this.newAlgorithm;
    }

    public CreateAlgorithmCommand(BasicFBType fbType, ECAction action) {
        this(fbType);
        this.action = action;
    }

    public CreateAlgorithmCommand(BasicFBType fbType, int index, String name) {
        this.fbType = fbType;
        this.index = index;
        this.name = name != null ? name : DEFAULT_ALGORITHM_NAME;
    }

    public void execute() {
        if (this.action != null) {
            this.oldAlgorithm = this.action.getAlgorithm();
        }
        this.newAlgorithm = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
        this.newAlgorithm.setComment(Messages.CreateAlgorithmCommand_NewAlgorithm);
        this.newAlgorithm.setText("");
        this.redo();
        this.newAlgorithm.setName(NameRepository.createUniqueName((INamedElement)this.newAlgorithm, (String)this.name));
    }

    public void undo() {
        if (this.action != null) {
            this.action.setAlgorithm(this.oldAlgorithm);
        }
        this.fbType.getAlgorithm().remove((Object)this.newAlgorithm);
    }

    public void redo() {
        if (this.action != null) {
            this.action.setAlgorithm((Algorithm)this.newAlgorithm);
        }
        this.fbType.getAlgorithm().add(this.index, (Object)this.newAlgorithm);
    }

    public Object getCreatedElement() {
        return this.newAlgorithm;
    }
}

