/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteECActionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ECCContentAndLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithm;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.figures.ECAlgorithmToolTipFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.preferences.PreferenceGetter;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ComboCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.ComboDirectEditManager;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.figures.GradientLabel;
import org.eclipse.fordiac.ide.gef.policies.EmptyXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.INamedElementRenameEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ComboBoxCellEditor;

public class ECActionAlgorithmEditPart
extends AbstractDirectEditableEditPart {
    private ECAlgorithmToolTipFigure algToolTip;
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            ECActionAlgorithmEditPart.this.refreshAlgLabel();
            ECActionAlgorithmEditPart.this.refreshAlgorithmToolTip(ECActionAlgorithmEditPart.this.getFigure());
        }
    };
    private final Adapter fbAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getEventType() == 1 && ECActionAlgorithmEditPart.this.getAction().getAlgorithm() != null && ECActionAlgorithmEditPart.this.getAction().getAlgorithm().getName().equals(notification.getNewValue())) {
                ECActionAlgorithmEditPart.this.refreshAlgLabel();
            }
        }
    };
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("ECCEditorAlgorithmColor")) {
                ECActionAlgorithmEditPart.this.getFigure().setBackgroundColor(PreferenceGetter.getColor("ECCEditorAlgorithmColor"));
            }
            if (event.getProperty().equals("ECCEditorAlgorithmBorderColor")) {
                ECActionAlgorithmEditPart.this.getFigure().setForegroundColor(PreferenceGetter.getColor("ECCEditorAlgorithmBorderColor"));
            }
        }
    };

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getAction().eAdapters().add((Object)this.adapter);
            if (this.getINamedElement() != null) {
                this.getINamedElement().eAdapters().remove((Object)this.getNameAdapter());
            }
            ECCContentAndLabelProvider.getFBType(this.getAction()).eAdapters().add((Object)this.fbAdapter);
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getAction().eAdapters().remove((Object)this.adapter);
            BasicFBType fbtype = ECCContentAndLabelProvider.getFBType(this.getAction());
            if (fbtype != null) {
                fbtype.eAdapters().remove((Object)this.fbAdapter);
            }
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new DeleteECActionCommand(ECActionAlgorithmEditPart.this.getAction());
            }
        });
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new INamedElementRenameEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                if (this.getHost() instanceof AbstractDirectEditableEditPart) {
                    List<Algorithm> algorithms = ECCContentAndLabelProvider.getAlgorithms(ECCContentAndLabelProvider.getFBType(ECActionAlgorithmEditPart.this.getAction()));
                    int selected = (Integer)request.getCellEditor().getValue();
                    Algorithm alg = null;
                    if (selected < algorithms.size()) {
                        alg = algorithms.get(selected);
                    }
                    return new ChangeAlgorithmCommand(ECActionAlgorithmEditPart.this.getAction(), alg);
                }
                return null;
            }

            protected void showCurrentEditValue(DirectEditRequest request) {
            }
        });
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EmptyXYLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                if (request != null && request.getNewObject() != null) {
                    Object object = request.getNewObject();
                    if (this.getHost() instanceof ECActionAlgorithmEditPart) {
                        ECActionAlgorithmEditPart editPart = (ECActionAlgorithmEditPart)this.getHost();
                        if (object instanceof STAlgorithm) {
                            return new CreateAlgorithmCommand(editPart.getBFB(), editPart.getAction());
                        }
                    }
                }
                return null;
            }
        });
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            request.setType((Object)"direct edit");
        }
        super.performRequest(request);
    }

    protected DirectEditManager createDirectEditManager() {
        return new ComboDirectEditManager((GraphicalEditPart)this, ComboBoxCellEditor.class, (CellEditorLocator)new ComboCellEditorLocator(this.getNameLabel()), this.getNameLabel());
    }

    public void performDirectEdit() {
        List<String> algNames = ECCContentAndLabelProvider.getAlgorithmNames(ECCContentAndLabelProvider.getFBType(this.getAction()));
        int selected = this.getAction().getAlgorithm() != null ? algNames.indexOf(this.getAction().getAlgorithm().getName()) : algNames.size() - 1;
        ((ComboDirectEditManager)this.getManager()).updateComboData(algNames);
        ((ComboDirectEditManager)this.getManager()).setSelectedItem(selected);
        this.getManager().show();
    }

    public ECActionAlgorithm getCastedModel() {
        return (ECActionAlgorithm)this.getModel();
    }

    public ECAction getAction() {
        return this.getCastedModel().getAction();
    }

    public BasicFBType getBFB() {
        return this.getAction().getECState().getECC().getBasicFBType();
    }

    public INamedElement getINamedElement() {
        return this.getAction().getAlgorithm();
    }

    public Label getNameLabel() {
        return (Label)this.getFigure();
    }

    protected IFigure createFigure() {
        GradientLabel algorithmLabel = new GradientLabel(((ZoomScalableFreeformRootEditPart)this.getRoot()).getZoomManager());
        algorithmLabel.setBackgroundColor(PreferenceGetter.getColor("ECCEditorAlgorithmColor"));
        algorithmLabel.setForegroundColor(PreferenceGetter.getColor("ECCEditorAlgorithmBorderColor"));
        algorithmLabel.setOpaque(true);
        algorithmLabel.setText(this.getAction().getAlgorithm() != null ? this.getAction().getAlgorithm().getName() : "");
        algorithmLabel.setBorder((Border)new LineBorder(){

            public Insets getInsets(IFigure figure) {
                return new Insets(3, 6, 3, 6);
            }
        });
        algorithmLabel.setTextAlignment(1);
        algorithmLabel.setLabelAlignment(1);
        this.algToolTip = new ECAlgorithmToolTipFigure();
        this.refreshAlgorithmToolTip((IFigure)algorithmLabel);
        return algorithmLabel;
    }

    private void refreshAlgLabel() {
        this.getNameLabel().setText(this.getAction().getAlgorithm() != null ? this.getAction().getAlgorithm().getName() : "");
    }

    private void refreshAlgorithmToolTip(IFigure iFigure) {
        if (this.algToolTip != null) {
            this.algToolTip.setAlgorithm(this.getCastedModel().getAction().getAlgorithm());
            if (this.getCastedModel().getAction().getAlgorithm() != null) {
                iFigure.setToolTip((IFigure)this.algToolTip);
            } else {
                iFigure.setToolTip(null);
            }
        }
    }
}

