/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.NamedElementComparator;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.dataexport.SystemExporter;
import org.eclipse.fordiac.ide.model.dataimport.SystemImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.Activator;
import org.eclipse.fordiac.ide.systemmanagement.DistributedSystemListener;
import org.eclipse.fordiac.ide.systemmanagement.FordiacResourceChangeListener;
import org.eclipse.fordiac.ide.systemmanagement.extension.ITagProvider;
import org.eclipse.fordiac.ide.systemmanagement.util.SystemPaletteManagement;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.widgets.Display;

public enum SystemManager {
    INSTANCE;

    public static final String FORDIAC_PROJECT_NATURE_ID = "org.eclipse.fordiac.ide.systemmanagement.FordiacNature";
    public static final String OLD_DISTRIBUTED_PROJECT_NATURE_ID = "org.fordiac.systemManagement.DistributedNature";
    static final String SYSTEM_FILE_ENDING = ".sys";
    private List<AutomationSystem> systems = new ArrayList<AutomationSystem>();
    private Map<AutomationSystem, Runnable> runningJobs = new HashMap<AutomationSystem, Runnable>();
    private final Map<AutomationSystem, ArrayList<ITagProvider>> tagProviders = new HashMap<AutomationSystem, ArrayList<ITagProvider>>();
    private List<DistributedSystemListener> listeners = new ArrayList<DistributedSystemListener>();
    private final Map<AutomationSystem, CommandStack> systemCommandStacks = new HashMap<AutomationSystem, CommandStack>();

    public CommandStack getCommandStack(AutomationSystem system) {
        if (!this.systemCommandStacks.containsKey(system)) {
            this.systemCommandStacks.put(system, new CommandStack());
        }
        return this.systemCommandStacks.get(system);
    }

    public void notifyListeners() {
        for (DistributedSystemListener listener : this.listeners) {
            listener.distributedSystemWorkspaceChanged();
        }
    }

    public void addWorkspaceListener(DistributedSystemListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private SystemManager() {
        TypeLibrary.getInstance();
        this.loadSystems();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new FordiacResourceChangeListener(this));
    }

    public void addSystem(AutomationSystem system) {
        this.systems.add(system);
        Collections.sort(this.systems, NamedElementComparator.INSTANCE);
        this.notifyListeners();
        Runnable job = SystemManager.createUniqueFBNamesValidity(system);
        this.runningJobs.put(system, job);
    }

    public void removeSystem(AutomationSystem system) {
        if (this.systems.remove(system)) {
            this.notifyListeners();
        }
    }

    public List<AutomationSystem> getSystems() {
        return this.systems;
    }

    public void loadSystems() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<AutomationSystem> oldSystems = new ArrayList<AutomationSystem>(this.systems);
        this.systems.clear();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.loadProject(project);
            ++n2;
        }
        this.removeOrphanedSystems(oldSystems);
    }

    private void removeOrphanedSystems(List<AutomationSystem> oldSystems) {
        for (AutomationSystem automationSystem : oldSystems) {
            if (this.getSystemForName(automationSystem.getName()) != null) continue;
            this.removeSystem(automationSystem);
        }
    }

    public AutomationSystem loadProject(IProject project) {
        AutomationSystem system = null;
        if (project.isOpen() && SystemManager.isDistributedSystem(project)) {
            long time1 = System.currentTimeMillis();
            system = this.loadSystem(project);
            long time2 = System.currentTimeMillis();
            System.out.println("Loading time for System (" + project.getName() + "): " + (time2 - time1) + " ms");
            if (system != null) {
                this.addSystem(system);
                Runnable runnable = this.runningJobs.get(system);
                if (runnable != null) {
                    Display.getDefault().asyncExec(runnable);
                }
            }
        }
        return system;
    }

    private static void initializePalette(AutomationSystem system) {
        DataTypeLibrary.getInstance();
        Palette palette = TypeLibrary.loadPalette((IContainer)system.getProject());
        palette.setProject(system.getProject());
        system.setPalette(palette);
    }

    private static boolean isDistributedSystem(IProject project) {
        boolean retval = false;
        try {
            retval = project.getNature(FORDIAC_PROJECT_NATURE_ID) != null || project.getNature(OLD_DISTRIBUTED_PROJECT_NATURE_ID) != null;
        }
        catch (CoreException e) {
            Activator.getDefault().logWarning(e.getMessage(), (Exception)((Object)e));
        }
        return retval;
    }

    private AutomationSystem loadSystem(IProject project) {
        try {
            project.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e1) {
            Activator.getDefault().logError(e1.getMessage(), (Exception)((Object)e1));
        }
        IFile systemFile = project.getFile(String.valueOf(project.getName()) + SYSTEM_FILE_ENDING);
        if (systemFile.exists()) {
            AutomationSystem system = this.createAutomationSystem(project);
            SystemImporter sysImporter = new SystemImporter(system);
            try {
                sysImporter.importSystem(systemFile.getContents());
            }
            catch (CoreException | TypeImportException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)e);
            }
            return system;
        }
        return null;
    }

    public AutomationSystem createAutomationSystem(IProject project) {
        AutomationSystem system = LibraryElementFactory.eINSTANCE.createAutomationSystem();
        system.setName(project.getName());
        system.setProject(project);
        SystemConfiguration sysConf = LibraryElementFactory.eINSTANCE.createSystemConfiguration();
        system.setSystemConfiguration(sysConf);
        SystemManager.initializePalette(system);
        this.loadTagProvider(system);
        return system;
    }

    private void loadTagProvider(AutomationSystem system) {
        IConfigurationElement[] elems;
        if (!this.tagProviders.containsKey(system)) {
            this.tagProviders.put(system, new ArrayList());
        }
        ArrayList<ITagProvider> providers = this.tagProviders.get(system);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.systemmanagement", "tagProvider");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                ITagProvider tagProvider;
                Object object = element.createExecutableExtension("Interface");
                if (object instanceof ITagProvider && (tagProvider = (ITagProvider)object).loadTagConfiguration(system.getProject().getLocation())) {
                    providers.add(tagProvider);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError("Error loading TagProviders!", (Exception)((Object)corex));
            }
            ++n2;
        }
    }

    public void saveTagProvider(AutomationSystem system, ITagProvider tagProvider) {
        IProject project = system.getProject();
        IPath projectPath = project.getLocation();
        tagProvider.saveTagConfiguration(projectPath);
    }

    public String getReplacedString(AutomationSystem system, String value) {
        ArrayList<ITagProvider> tagProvider = this.tagProviders.get(system);
        String result = null;
        for (ITagProvider iTagProvider : tagProvider) {
            result = iTagProvider.getReplacedString(value);
            if (result != null) break;
        }
        return result;
    }

    private static Runnable createUniqueFBNamesValidity(final AutomationSystem system) {
        return new Runnable(){

            @Override
            public void run() {
                for (Application app : system.getApplication()) {
                    this.checkAndCreateAnnotation(system, (List<FBNetworkElement>)app.getFBNetwork().getNetworkElements());
                }
                this.checkDevices(system, (EList<Device>)system.getSystemConfiguration().getDevices());
            }

            private void checkDevices(AutomationSystem system2, EList<Device> devices) {
                for (Device device : devices) {
                    for (Resource res : device.getResource()) {
                        this.checkAndCreateAnnotation(system2, (List<FBNetworkElement>)res.getFBNetwork().getNetworkElements());
                    }
                }
            }

            private void checkAndCreateAnnotation(AutomationSystem system2, List<FBNetworkElement> element) {
                for (FBNetworkElement fb : element) {
                    fb.getAnnotations().clear();
                    if (!(element instanceof SubApp)) continue;
                    this.checkAndCreateAnnotation(system2, (List<FBNetworkElement>)((SubApp)element).getFbNetwork().getNetworkElements());
                }
            }
        };
    }

    public void saveSystem(AutomationSystem system) {
        IProject project = system.getProject();
        SystemExporter systemExporter = new SystemExporter(system);
        systemExporter.saveSystem(project.getFile(String.valueOf(system.getName()) + SYSTEM_FILE_ENDING));
    }

    public AutomationSystem getSystemForName(String string) {
        for (AutomationSystem system : this.systems) {
            if (!system.getName().equals(string)) continue;
            return system;
        }
        return null;
    }

    private static IProject getProjectHandle(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    private static String getValidSystemName(String name) {
        if (SystemManager.isUniqueSystemName(name)) {
            return name;
        }
        int i = 1;
        String temp = String.valueOf(name) + "_" + i;
        while (INSTANCE.getSystemForName(temp) != null || SystemManager.getProjectHandle(temp).exists()) {
            temp = String.valueOf(name) + "_" + ++i;
        }
        return temp;
    }

    public static boolean isUniqueSystemName(String name) {
        return INSTANCE.getSystemForName(name) == null && !SystemManager.getProjectHandle(name).exists();
    }

    public ITagProvider getTagProvider(Class<?> class1, AutomationSystem system) {
        if (!this.tagProviders.containsKey(system)) {
            this.tagProviders.put(system, new ArrayList());
        }
        ITagProvider provider = null;
        ArrayList<ITagProvider> tagProviderList = this.tagProviders.get(system);
        if (tagProviderList != null) {
            for (ITagProvider iTagProvider : tagProviderList) {
                if (!iTagProvider.getClass().equals(class1)) continue;
                provider = iTagProvider;
                break;
            }
        }
        if (provider == null) {
            try {
                Object obj = class1.newInstance();
                if (obj instanceof ITagProvider) {
                    provider = (ITagProvider)obj;
                    provider.initialzeNewTagProvider();
                    this.saveTagProvider(system, provider);
                    tagProviderList.add(provider);
                }
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
        return provider;
    }

    public Palette getPalette(IProject project) {
        AutomationSystem srcSystem = this.getSystemForName(project.getName());
        if (srcSystem != null) {
            return srcSystem.getPalette();
        }
        return TypeLibrary.getInstance().getPalette();
    }

    public AutomationSystem createLocalProject(String projectName) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String systemName = SystemManager.getValidSystemName(projectName);
            IProject project = root.getProject(systemName);
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            description.setNatureIds(new String[]{FORDIAC_PROJECT_NATURE_ID});
            project.create(description, (IProgressMonitor)monitor);
            project.open((IProgressMonitor)monitor);
            SystemPaletteManagement.copyToolTypeLibToProject(project);
            AutomationSystem system = this.createAutomationSystem(project);
            INSTANCE.addSystem(system);
            AutomationSystem sys2 = INSTANCE.getSystemForName(system.getName());
            if (sys2 != null && !sys2.equals(system)) {
                system = sys2;
            }
            AutomationSystem automationSystem = system;
            return automationSystem;
        }
        catch (CoreException x) {
            Activator.getDefault().logError(x.getMessage(), (Exception)((Object)x));
        }
        finally {
            monitor.done();
        }
        return null;
    }
}

