/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.metrics.analyzers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.metrics.analyzers.AbstractCodeMetricAnalyzer;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricData;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class CyclomaticComplexity
extends AbstractCodeMetricAnalyzer {
    static final String[] CONDITIONS = new String[]{"IF", "FOR", "WHILE", "REPEAT"};
    List<MetricData> metrics = new ArrayList<MetricData>();
    double ccapp = 0.0;

    @Override
    public void calculateMetrics(INamedElement element) {
        super.calculateMetrics(element);
        this.metrics.add(0, new MetricData("Cyclomatic Number " + element.getName(), this.ccapp));
    }

    @Override
    public List<MetricData> getResults() {
        return this.metrics;
    }

    @Override
    protected void analyzeBFB(BasicFBType basicFBType) {
        ECC ecc = basicFBType.getECC();
        double ccfb = ecc.getECTransition().size() - ecc.getECState().size() + 2;
        for (ECState state : ecc.getECState()) {
            for (ECAction action : state.getECAction()) {
                if (action.getAlgorithm() == null) continue;
                ccfb += CyclomaticComplexity.analyzeAlgorithm(action.getAlgorithm());
            }
        }
        this.ccapp += ccfb;
        this.metrics.add(new MetricData("Cyclomatic Number " + basicFBType.getName(), ccfb));
    }

    private static double analyzeAlgorithm(Algorithm algorithm) {
        double ccAlg = 0.0;
        String algText = algorithm.toString();
        int saveIndex = 0;
        String[] stringArray = CONDITIONS;
        int n = CONDITIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String cond = stringArray[n2];
            int lastIndex = 0;
            while (-1 != lastIndex) {
                saveIndex = cond.equals("REPEAT") ? algText.indexOf(String.valueOf(cond) + "\r\n", lastIndex) : algText.toString().indexOf(String.valueOf(cond) + " ", lastIndex);
                if (saveIndex == 0 || -1 == (lastIndex = saveIndex)) continue;
                ccAlg += 1.0;
                lastIndex += cond.length();
            }
            ++n2;
        }
        return ccAlg;
    }
}

