/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.editparts.TestEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.editparts.TestEventEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.ISetValueListener;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.ITriggerEventListener;
import org.eclipse.fordiac.ide.gef.editparts.IEditPartCreator;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.impl.PositionableElementImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class TestElement
extends PositionableElementImpl
implements IEditPartCreator {
    private String monitoringElement;
    private IInterfaceElement element;
    private String value;
    private int nrOfHistory = 500;
    private List<String> historyValues = new ArrayList<String>(this.nrOfHistory);
    private List<Integer> historyCycles = new ArrayList<Integer>(this.nrOfHistory);
    private List<Long> historySec = new ArrayList<Long>(this.nrOfHistory);
    private List<Long> historyUSec = new ArrayList<Long>(this.nrOfHistory);
    private int currentInt = 0;
    private FB fb;
    private TestEditPart part;
    private final List<ISetValueListener> valueListeners = new ArrayList<ISetValueListener>();
    private final List<ITriggerEventListener> eventListners = new ArrayList<ITriggerEventListener>();

    public String getValue() {
        return this.value;
    }

    public String getCurrentValue() {
        if (this.currentInt == 0) {
            return "0";
        }
        return this.historyValues.get(this.currentInt % this.nrOfHistory - 1);
    }

    public void setValue(String value) {
        this.value = value;
        for (ISetValueListener valueListener : this.valueListeners) {
            valueListener.setValue(this, value);
        }
    }

    public FB getFb() {
        return this.fb;
    }

    public void setFb(FB fb) {
        this.fb = fb;
    }

    public String getMonitoringElementAsString() {
        return this.monitoringElement;
    }

    public void setMonitoringElement(String monitoringElement) {
        this.monitoringElement = monitoringElement;
    }

    public String getResourceString() {
        return String.valueOf(this.getFBString()) + "_RES";
    }

    public String getFBString() {
        return "_" + this.getFb().getType().getName();
    }

    public String getPortString() {
        return this.getInterfaceElement().getName();
    }

    public void setElement(IInterfaceElement element) {
        this.element = element;
    }

    public IInterfaceElement getInterfaceElement() {
        return this.element;
    }

    public TestEditPart getPart() {
        return this.part;
    }

    public EditPart createEditPart() {
        if (this.part == null) {
            this.part = this.getInterfaceElement() instanceof Event && this.getInterfaceElement().isIsInput() ? new TestEventEditPart() : new TestEditPart();
        }
        return this.part;
    }

    public void addSetValueListener(ISetValueListener listener) {
        if (!this.valueListeners.contains(listener)) {
            this.valueListeners.add(listener);
        }
    }

    public void addTriggerEventListener(ITriggerEventListener listener) {
        if (!this.eventListners.contains(listener)) {
            this.eventListners.add(listener);
        }
    }

    public void sendEvent() {
        for (ITriggerEventListener eventListner : this.eventListners) {
            eventListner.sendEvent(this);
        }
    }

    public void updateValue(final String value, int cycle) {
        this.historyValues.add(this.currentInt % this.nrOfHistory, value);
        this.historyCycles.add(this.currentInt % this.nrOfHistory, cycle);
        ++this.currentInt;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestElement.this.getPart().setValue(value);
            }
        });
    }

    public void setColor(Color color) {
        Display.getDefault().asyncExec(() -> this.part.setBackgroundColor(color));
    }
}

