/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.properties;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.VarContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.VarDeclarationLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.properties.AdapterInterfaceElementSection;
import org.eclipse.fordiac.ide.model.commands.create.WithCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteWithCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class EventInterfaceElementSection
extends AdapterInterfaceElementSection {
    private TableViewer withEventsViewer;
    private Group eventComposite;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createEventSection(this.getRightComposite());
    }

    private void createEventSection(Composite parent) {
        this.eventComposite = this.getWidgetFactory().createGroup(parent, FordiacMessages.With);
        this.eventComposite.setLayout((Layout)new GridLayout(1, false));
        this.eventComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.withEventsViewer = TableWidgetFactory.createPropertyTableViewer((Composite)this.eventComposite, (int)32);
        this.withEventsViewer.setContentProvider((IContentProvider)new VarContentProvider());
        this.withEventsViewer.setLabelProvider((IBaseLabelProvider)new VarDeclarationLabelProvider());
        Table tableWith = this.withEventsViewer.getTable();
        this.configureTableLayout(tableWith);
        tableWith.addListener(13, event -> {
            if (event.detail == 32) {
                TableItem checkedItem = (TableItem)event.item;
                VarDeclaration variable = (VarDeclaration)checkedItem.getData();
                With with = variable.getWiths().stream().filter(w -> w.eContainer().equals(this.getType())).findFirst().orElse(null);
                if (checkedItem.getChecked()) {
                    if (with == null) {
                        this.executeCommand((Command)new WithCreateCommand(this.getType(), variable));
                    }
                } else if (with != null) {
                    this.executeCommand((Command)new DeleteWithCommand(with));
                }
            }
        });
    }

    private void configureTableLayout(Table tableWith) {
        TableColumn column1 = new TableColumn(this.withEventsViewer.getTable(), 16384);
        column1.setText(FordiacMessages.Variable);
        TableColumn column2 = new TableColumn(this.withEventsViewer.getTable(), 16384);
        column2.setText(FordiacMessages.DataType);
        TableColumn column3 = new TableColumn(this.withEventsViewer.getTable(), 16384);
        column3.setText(FordiacMessages.Comment);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 100));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 100));
        tableWith.setLayout((Layout)layout);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.eventComposite.setVisible(!(this.getType().eContainer().eContainer() instanceof SubAppType));
        if (this.commandStack == null) {
            this.withEventsViewer.setInput(null);
            Arrays.stream(this.withEventsViewer.getTable().getItems()).forEach(item -> item.setGrayed(true));
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.getType() != null) {
            this.withEventsViewer.setInput((Object)this.getType());
            Arrays.stream(this.withEventsViewer.getTable().getItems()).forEach(item -> item.setChecked(false));
            this.getType().getWith().stream().filter(with -> with.getVariables() != null).map(with -> this.withEventsViewer.testFindItem((Object)with.getVariables())).filter(item -> item instanceof TableItem).forEach(item -> ((TableItem)item).setChecked(true));
        }
        this.commandStack = commandStackBuffer;
    }

    @Override
    public void setTypeDropdown() {
        this.typeCombo.removeAll();
        this.typeCombo.add(FordiacMessages.Event);
        this.typeCombo.select(0);
    }

    @Override
    protected DataType getTypeForSelection(String text) {
        return null;
    }

    protected Event getType() {
        return (Event)super.getType();
    }
}

