/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;
import java.util.Objects;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;

public class StringToNumberConverter<T extends Number>
extends NumberFormatConverter<Object, T> {
    private Class<?> toType;
    private NumberFormat numberFormat;
    private final Number min;
    private final Number max;
    private final Class<?> boxedType;
    private static final Integer MIN_INTEGER = Integer.MIN_VALUE;
    private static final Integer MAX_INTEGER = Integer.MAX_VALUE;
    private static final Double MIN_DOUBLE = -1.7976931348623157E308;
    private static final Double MAX_DOUBLE = Double.MAX_VALUE;
    private static final Long MIN_LONG = Long.MIN_VALUE;
    private static final Long MAX_LONG = Long.MAX_VALUE;
    private static final Float MIN_FLOAT = Float.valueOf(-3.4028235E38f);
    private static final Float MAX_FLOAT = Float.valueOf(Float.MAX_VALUE);
    private static final Short MIN_SHORT = Short.MIN_VALUE;
    private static final Short MAX_SHORT = Short.MAX_VALUE;
    private static final Byte MIN_BYTE = -128;
    private static final Byte MAX_BYTE = 127;
    static Class<?> icuBigDecimal = null;
    static Method icuBigDecimalScale = null;
    static Method icuBigDecimalUnscaledValue = null;

    private StringToNumberConverter(NumberFormat numberFormat, Class<T> toType, Number min, Number max, Class<T> boxedType) {
        super(String.class, toType, numberFormat);
        try {
            icuBigDecimal = Class.forName("com.ibm.icu.math.BigDecimal");
            icuBigDecimalScale = icuBigDecimal.getMethod("scale", new Class[0]);
            icuBigDecimalUnscaledValue = icuBigDecimal.getMethod("unscaledValue", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {}
        this.toType = Objects.requireNonNull(toType);
        this.numberFormat = Objects.requireNonNull(numberFormat);
        this.min = min;
        this.max = max;
        this.boxedType = Objects.requireNonNull(boxedType);
    }

    @Override
    public T convert(Object fromObject) {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse(fromObject, this.numberFormat, this.toType.isPrimitive());
        if (result.getPosition() != null) {
            throw new IllegalArgumentException(StringToNumberParser.createParseErrorMessage((String)fromObject, result.getPosition()));
        }
        if (result.getNumber() == null) {
            return null;
        }
        if (Integer.class.equals(this.boxedType)) {
            if (StringToNumberParser.inIntegerRange(result.getNumber())) {
                return (T)Integer.valueOf(result.getNumber().intValue());
            }
        } else if (Double.class.equals(this.boxedType)) {
            if (StringToNumberParser.inDoubleRange(result.getNumber())) {
                return (T)Double.valueOf(result.getNumber().doubleValue());
            }
        } else if (Long.class.equals(this.boxedType)) {
            if (StringToNumberParser.inLongRange(result.getNumber())) {
                return (T)Long.valueOf(result.getNumber().longValue());
            }
        } else if (Float.class.equals(this.boxedType)) {
            if (StringToNumberParser.inFloatRange(result.getNumber())) {
                return (T)Float.valueOf(result.getNumber().floatValue());
            }
        } else {
            if (BigInteger.class.equals(this.boxedType)) {
                Number n = result.getNumber();
                if (n instanceof Long) {
                    return (T)BigInteger.valueOf(n.longValue());
                }
                if (n instanceof BigInteger) {
                    return (T)n;
                }
                if (n instanceof BigDecimal) {
                    return (T)((BigDecimal)n).toBigInteger();
                }
                return (T)BigDecimal.valueOf(n.doubleValue()).toBigInteger();
            }
            if (BigDecimal.class.equals(this.boxedType)) {
                Number n = result.getNumber();
                if (n instanceof Long) {
                    return (T)BigDecimal.valueOf(n.longValue());
                }
                if (n instanceof BigInteger) {
                    return (T)new BigDecimal((BigInteger)n);
                }
                if (n instanceof BigDecimal) {
                    return (T)n;
                }
                if (icuBigDecimal != null && icuBigDecimal.isInstance(n)) {
                    try {
                        int scale = (Integer)icuBigDecimalScale.invoke((Object)n, new Object[0]);
                        BigInteger unscaledValue = (BigInteger)icuBigDecimalUnscaledValue.invoke((Object)n, new Object[0]);
                        return (T)new BigDecimal(unscaledValue, scale);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IllegalArgumentException("Error (IllegalAccessException) converting BigDecimal using ICU");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new IllegalArgumentException("Error (InvocationTargetException) converting BigDecimal using ICU");
                    }
                }
                if (n instanceof Double) {
                    BigDecimal bd = BigDecimal.valueOf(n.doubleValue());
                    if (bd.scale() == 0) {
                        return (T)bd;
                    }
                    throw new IllegalArgumentException("Non-integral Double value returned from NumberFormat which cannot be accurately stored in a BigDecimal due to lost precision. Consider using ICU4J or Java 5 which can properly format and parse these types.");
                }
            } else if (Short.class.equals(this.boxedType)) {
                if (StringToNumberParser.inShortRange(result.getNumber())) {
                    return (T)Short.valueOf(result.getNumber().shortValue());
                }
            } else if (Byte.class.equals(this.boxedType) && StringToNumberParser.inByteRange(result.getNumber())) {
                return (T)Byte.valueOf(result.getNumber().byteValue());
            }
        }
        if (this.min != null && this.max != null) {
            throw new IllegalArgumentException(StringToNumberParser.createOutOfRangeMessage(this.min, this.max, (Format)this.numberFormat));
        }
        throw new IllegalArgumentException("Could not convert [" + fromObject + "] to type [" + this.toType + "]");
    }

    public static StringToNumberConverter<Integer> toInteger(boolean primitive) {
        return StringToNumberConverter.toInteger(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter<Integer> toInteger(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter<Integer>(numberFormat, primitive ? Integer.TYPE : Integer.class, MIN_INTEGER, MAX_INTEGER, Integer.class);
    }

    public static StringToNumberConverter<Double> toDouble(boolean primitive) {
        return StringToNumberConverter.toDouble(NumberFormat.getNumberInstance(), primitive);
    }

    public static StringToNumberConverter<Double> toDouble(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter<Double>(numberFormat, primitive ? Double.TYPE : Double.class, MIN_DOUBLE, MAX_DOUBLE, Double.class);
    }

    public static StringToNumberConverter<Long> toLong(boolean primitive) {
        return StringToNumberConverter.toLong(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter<Long> toLong(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter<Long>(numberFormat, primitive ? Long.TYPE : Long.class, MIN_LONG, MAX_LONG, Long.class);
    }

    public static StringToNumberConverter<Float> toFloat(boolean primitive) {
        return StringToNumberConverter.toFloat(NumberFormat.getNumberInstance(), primitive);
    }

    public static StringToNumberConverter<Float> toFloat(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter<Float>(numberFormat, primitive ? Float.TYPE : Float.class, MIN_FLOAT, MAX_FLOAT, Float.class);
    }

    public static StringToNumberConverter<BigInteger> toBigInteger() {
        return StringToNumberConverter.toBigInteger(NumberFormat.getIntegerInstance());
    }

    public static StringToNumberConverter<BigInteger> toBigInteger(NumberFormat numberFormat) {
        return new StringToNumberConverter<BigInteger>(numberFormat, BigInteger.class, null, null, BigInteger.class);
    }

    public static StringToNumberConverter<BigDecimal> toBigDecimal() {
        return StringToNumberConverter.toBigDecimal(NumberFormat.getNumberInstance());
    }

    public static StringToNumberConverter<BigDecimal> toBigDecimal(NumberFormat numberFormat) {
        return new StringToNumberConverter<BigDecimal>(numberFormat, BigDecimal.class, null, null, BigDecimal.class);
    }

    public static StringToNumberConverter<Short> toShort(boolean primitive) {
        return StringToNumberConverter.toShort(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter<Short> toShort(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter<Short>(numberFormat, primitive ? Short.TYPE : Short.class, MIN_SHORT, MAX_SHORT, Short.class);
    }

    public static StringToNumberConverter<Byte> toByte(boolean primitive) {
        return StringToNumberConverter.toByte(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter<Byte> toByte(NumberFormat numberFormat, boolean primitive) {
        return new StringToNumberConverter<Byte>(numberFormat, primitive ? Byte.TYPE : Byte.class, MIN_BYTE, MAX_BYTE, Byte.class);
    }
}

