/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

class FBNetworkImporter
extends CommonElementImporter {
    private final Palette palette;
    private final FBNetwork fbNetwork;
    private final InterfaceList interfaceList;
    protected final Map<String, FBNetworkElement> fbNetworkElementMap = new HashMap<String, FBNetworkElement>();

    public FBNetworkImporter(Palette palette, XMLStreamReader reader) {
        this(palette, LibraryElementFactory.eINSTANCE.createFBNetwork(), LibraryElementFactory.eINSTANCE.createInterfaceList(), reader);
    }

    public FBNetworkImporter(Palette palette, FBNetwork fbNetwork, InterfaceList interfaceList, XMLStreamReader reader) {
        super(reader);
        this.palette = palette;
        this.fbNetwork = fbNetwork;
        this.interfaceList = interfaceList;
        fbNetwork.getNetworkElements().forEach(element -> {
            FBNetworkElement fBNetworkElement = this.fbNetworkElementMap.put(element.getName(), (FBNetworkElement)element);
        });
    }

    protected FBNetworkImporter(Palette palette, FBNetwork fbNetwork, XMLStreamReader reader) {
        this(palette, fbNetwork, LibraryElementFactory.eINSTANCE.createInterfaceList(), reader);
    }

    public Palette getPalette() {
        return this.palette;
    }

    public FBNetwork getFbNetwork() {
        return this.fbNetwork;
    }

    public FBNetwork parseFBNetwork(String networkNodeName) throws TypeImportException, XMLStreamException {
        this.processChildren(networkNodeName, name -> {
            switch (name) {
                case "FB": {
                    this.parseFB();
                    break;
                }
                case "EventConnections": {
                    this.parseConnectionList(LibraryElementPackage.eINSTANCE.getEventConnection(), this.fbNetwork.getEventConnections(), "EventConnections");
                    break;
                }
                case "DataConnections": {
                    this.parseConnectionList(LibraryElementPackage.eINSTANCE.getDataConnection(), this.fbNetwork.getDataConnections(), "DataConnections");
                    break;
                }
                case "AdapterConnections": {
                    this.parseConnectionList(LibraryElementPackage.eINSTANCE.getAdapterConnection(), this.fbNetwork.getAdapterConnections(), "AdapterConnections");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        return this.fbNetwork;
    }

    protected void parseFB() throws TypeImportException, XMLStreamException {
        FB fb = LibraryElementFactory.eINSTANCE.createFB();
        this.readNameCommentAttributes(fb);
        FBTypePaletteEntry entry = this.getTypeEntry();
        if (entry != null) {
            fb.setPaletteEntry(entry);
            fb.setInterface((InterfaceList)EcoreUtil.copy((EObject)fb.getType().getInterfaceList()));
        } else {
            fb.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        }
        this.getXandY(fb);
        this.configureParameters(fb.getInterface(), "FB");
        for (VarDeclaration var : fb.getInterface().getInputVars()) {
            if (var.getValue() != null) continue;
            var.setValue(LibraryElementFactory.eINSTANCE.createValue());
        }
        this.fbNetwork.getNetworkElements().add((Object)fb);
        this.fbNetworkElementMap.put(fb.getName(), fb);
    }

    private FBTypePaletteEntry getTypeEntry() {
        String typeFbElement = this.getAttributeValue("Type");
        if (typeFbElement != null) {
            return this.palette.getFBTypeEntry(typeFbElement);
        }
        return null;
    }

    protected void configureParameters(InterfaceList interfaceList, String parentNodeName) throws TypeImportException, XMLStreamException {
        this.processChildren(parentNodeName, name -> {
            if ("Parameter".equals(name)) {
                VarDeclaration paramter = this.parseParameter();
                VarDeclaration vInput = FBNetworkImporter.getVarNamed(interfaceList, paramter.getName(), true);
                if (vInput != null) {
                    vInput.setValue(paramter.getValue());
                }
                return true;
            }
            return false;
        });
    }

    protected <T extends Connection> void parseConnectionList(EClass conType, EList<T> connectionlist, String parentNodeName) throws XMLStreamException, TypeImportException {
        this.processChildren(parentNodeName, name -> {
            if ("Connection".equals("Connection")) {
                Object connection = this.parseConnection(conType);
                if (connection != null) {
                    connectionlist.add(connection);
                }
                this.proceedToEndElementNamed("Connection");
                return true;
            }
            return false;
        });
    }

    private <T extends Connection> T parseConnection(EClass conType) {
        String commentElement;
        String sourceElement;
        Connection connection = (Connection)LibraryElementFactory.eINSTANCE.create(conType);
        connection.setResTypeConnection(false);
        String destinationElement = this.getAttributeValue("Destination");
        if (destinationElement != null) {
            IInterfaceElement destination = this.getConnectionEndPoint(destinationElement, conType, true);
            if (destination != null) {
                connection.setDestination(destination);
            } else {
                Activator.getDefault().logError("Connection destination not found: " + destinationElement);
                return null;
            }
        }
        if ((sourceElement = this.getAttributeValue("Source")) != null) {
            IInterfaceElement source = this.getConnectionEndPoint(sourceElement, conType, false);
            if (source != null) {
                connection.setSource(source);
            } else {
                Activator.getDefault().logError("Connection source not found: " + sourceElement);
                return null;
            }
        }
        if ((commentElement = this.getAttributeValue("Comment")) != null) {
            connection.setComment(commentElement);
        }
        this.parseConnectionRouting(connection);
        return (T)connection;
    }

    private void parseConnectionRouting(Connection connection) {
        String dyElement;
        String dx2Element;
        String dx1Element = this.getAttributeValue("dx1");
        if (dx1Element != null) {
            connection.setDx1(FBNetworkImporter.parseConnectionValue(dx1Element));
        }
        if ((dx2Element = this.getAttributeValue("dx2")) != null) {
            connection.setDx2(FBNetworkImporter.parseConnectionValue(dx2Element));
        }
        if ((dyElement = this.getAttributeValue("dy")) != null) {
            connection.setDy(FBNetworkImporter.parseConnectionValue(dyElement));
        }
    }

    private IInterfaceElement getConnectionEndPoint(String path, EClass conType, boolean isInput) {
        FBNetworkElement element;
        String[] split = path.split("\\.");
        if (1 == split.length) {
            return this.getContainingInterfaceElement(path, conType, isInput);
        }
        if (2 == split.length && (element = this.findFBNetworkElement(split[0])) != null) {
            return FBNetworkImporter.getInterfaceElement(element.getInterface(), split[1], conType, isInput);
        }
        return null;
    }

    protected IInterfaceElement getContainingInterfaceElement(String interfaceElement, EClass conType, boolean isInput) {
        return FBNetworkImporter.getInterfaceElement(this.interfaceList, interfaceElement, conType, !isInput);
    }

    private static IInterfaceElement getInterfaceElement(InterfaceList il, String interfaceElement, EClass conType, boolean isInput) {
        EList<? extends IInterfaceElement> ieList = FBNetworkImporter.getInterfaceElementList(il, conType, isInput);
        for (IInterfaceElement ie : ieList) {
            if (!ie.getName().equals(interfaceElement)) continue;
            return ie;
        }
        return null;
    }

    private static EList<? extends IInterfaceElement> getInterfaceElementList(InterfaceList il, EClass conType, boolean isInput) {
        if (isInput) {
            if (LibraryElementPackage.eINSTANCE.getEventConnection() == conType) {
                return il.getEventInputs();
            }
            if (LibraryElementPackage.eINSTANCE.getDataConnection() == conType) {
                return il.getInputVars();
            }
            if (LibraryElementPackage.eINSTANCE.getAdapterConnection().equals(conType)) {
                return il.getSockets();
            }
        } else {
            if (LibraryElementPackage.eINSTANCE.getEventConnection() == conType) {
                return il.getEventOutputs();
            }
            if (LibraryElementPackage.eINSTANCE.getDataConnection() == conType) {
                return il.getOutputVars();
            }
            if (LibraryElementPackage.eINSTANCE.getAdapterConnection().equals(conType)) {
                return il.getPlugs();
            }
        }
        return null;
    }

    protected FBNetworkElement findFBNetworkElement(String fbName) {
        return this.fbNetworkElementMap.get(fbName);
    }

    protected static VarDeclaration getVarNamed(InterfaceList interfaceList, String varName, boolean input) {
        VarDeclaration retVal;
        boolean hasType = true;
        if (interfaceList.eContainer() instanceof FB) {
            boolean bl = hasType = ((FB)interfaceList.eContainer()).getPaletteEntry() != null;
        }
        if (hasType) {
            retVal = interfaceList.getVariable(varName);
            if (retVal != null && retVal.isIsInput() != input) {
                retVal = null;
            }
        } else {
            retVal = FBNetworkImporter.createVarDecl(interfaceList, varName, input);
        }
        return retVal;
    }

    private static VarDeclaration createVarDecl(InterfaceList interfaceList, String varName, boolean input) {
        VarDeclaration var = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        var.setName(varName);
        var.setIsInput(input);
        if (input) {
            interfaceList.getInputVars().add((Object)var);
        } else {
            interfaceList.getOutputVars().add((Object)var);
        }
        return var;
    }

    private static int parseConnectionValue(String value) {
        try {
            return CoordinateConverter.INSTANCE.convertFrom1499XML(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

