/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.application.editors.NewInstanceDirectEditManager;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.editparts.FBEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateSubAppInstanceCommand;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;

public class FBNetworkRootEditPart
extends ZoomScalableFreeformRootEditPart {
    private final FBNetwork fbNetwork;
    private final Palette palette;
    private NewInstanceDirectEditManager manager;

    public FBNetworkRootEditPart(FBNetwork fbNetwork, Palette palette, IWorkbenchPartSite site, ActionRegistry actionRegistry) {
        super(site, actionRegistry);
        this.fbNetwork = fbNetwork;
        this.palette = palette;
    }

    public DragTracker getDragTracker(Request req) {
        FBNetworkMarqueeDragTracker dragTracker = new FBNetworkMarqueeDragTracker();
        dragTracker.setMarqueeBehavior(MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS);
        return dragTracker;
    }

    public void performRequest(Request request) {
        if ((request.getType() == "direct edit" || request.getType() == "open") && request instanceof SelectionRequest) {
            this.performDirectEdit((SelectionRequest)request);
        } else {
            super.performRequest(request);
        }
    }

    private NewInstanceDirectEditManager getManager() {
        if (this.manager == null) {
            this.manager = new NewInstanceDirectEditManager((GraphicalEditPart)this, this.palette);
        }
        return this.manager;
    }

    private void performDirectEdit(SelectionRequest request) {
        NewInstanceDirectEditManager directEditManager = this.getManager();
        directEditManager.updateRefPosition(new org.eclipse.swt.graphics.Point(request.getLocation().x, request.getLocation().y));
        if (request.getExtendedData().isEmpty()) {
            directEditManager.show();
        } else {
            Object key = request.getExtendedData().keySet().iterator().next();
            if (key instanceof String) {
                directEditManager.show((String)key);
            }
        }
    }

    public Command getCommand(Request request) {
        if (request instanceof DirectEditRequest) {
            AbstractCreateFBNetworkElementCommand cmd = this.getDirectEditCommand((DirectEditRequest)request);
            if (cmd != null) {
                this.getViewer().getEditDomain().getCommandStack().execute((Command)cmd);
                EditPart part = (EditPart)this.getViewer().getEditPartRegistry().get(cmd.getElement());
                this.getViewer().select(part);
            }
            return null;
        }
        return super.getCommand(request);
    }

    private AbstractCreateFBNetworkElementCommand getDirectEditCommand(DirectEditRequest request) {
        Object value = request.getCellEditor().getValue();
        org.eclipse.swt.graphics.Point refPoint = this.getInsertPos();
        if (value instanceof FBTypePaletteEntry) {
            return new FBCreateCommand((FBTypePaletteEntry)value, this.fbNetwork, refPoint.x, refPoint.y);
        }
        if (value instanceof SubApplicationTypePaletteEntry) {
            return new CreateSubAppInstanceCommand((SubApplicationTypePaletteEntry)value, this.fbNetwork, refPoint.x, refPoint.y);
        }
        return null;
    }

    private org.eclipse.swt.graphics.Point getInsertPos() {
        org.eclipse.swt.graphics.Point location = this.getManager().getLocator().getRefPoint();
        FigureCanvas figureCanvas = (FigureCanvas)this.getViewer().getControl();
        Point viewLocation = figureCanvas.getViewport().getViewLocation();
        location.x += viewLocation.x;
        location.y += viewLocation.y;
        Point insertPos = new Point(location.x, location.y).scale(1.0 / this.getZoomManager().getZoom());
        return new org.eclipse.swt.graphics.Point(insertPos.x, insertPos.y);
    }

    private class FBNetworkMarqueeDragTracker
    extends ZoomScalableFreeformRootEditPart.AdvancedMarqueeDragTracker {
        static final int DEFAULT_MODE = 0;
        static final int TOGGLE_MODE = 1;

        private FBNetworkMarqueeDragTracker() {
            super((ZoomScalableFreeformRootEditPart)FBNetworkRootEditPart.this);
        }

        protected void performMarqueeSelect() {
            Collection marqueeSelectedEditParts = this.calculateMarqueeSelectedEditParts();
            LinkedHashSet<EditPart> editPartsToSelect = new LinkedHashSet<EditPart>();
            HashSet<EditPart> editPartsToDeselect = new HashSet<EditPart>();
            for (EditPart affectedEditPart : marqueeSelectedEditParts) {
                if (affectedEditPart.getSelected() == 0 || this.getCurrentSelectionMode() != 1) {
                    if (!(affectedEditPart instanceof FBEditPart) && !(affectedEditPart instanceof ConnectionEditPart) && !(affectedEditPart instanceof SubAppForFBNetworkEditPart)) continue;
                    editPartsToSelect.add(affectedEditPart);
                    continue;
                }
                editPartsToDeselect.add(affectedEditPart);
            }
            if (this.getCurrentSelectionMode() != 0) {
                editPartsToSelect.addAll(this.getCurrentViewer().getSelectedEditParts());
                editPartsToSelect.removeAll(editPartsToDeselect);
            }
            this.getCurrentViewer().setSelection((ISelection)new StructuredSelection(editPartsToSelect.toArray()));
        }
    }
}

