/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.wizards;

import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class SaveAsSubappWizardPage
extends WizardNewFileCreationPage {
    private static final String STORE_OPEN_TYPE_ID = "SUBAPP_SECTION.STORE_OPEN_TYPE_ID";
    private static final String STORE_REPLACE_SOURCE_ID = "SUBAPP_SECTION.STORE_REPLACE_SOURCE_ID";
    private boolean openType = true;
    private boolean replaceSource = true;
    private Composite advancedComposite;
    private int advancedCompositeHeight = -1;

    public SaveAsSubappWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(Messages.SaveAsSubApplicationTypeAction_WizardPageTitel);
        this.setDescription(Messages.SaveAsSubApplicationTypeAction_WizardPageDescription);
        this.setAllowExistingResources(true);
    }

    public boolean getOpenType() {
        return this.openType;
    }

    public boolean getReplaceSoure() {
        return this.replaceSource;
    }

    protected String getNewFileLabel() {
        return Messages.SaveAsSubApplicationTypeAction_WizardPageNameLabel;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.restoreWidgetValues();
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_OPEN_TYPE_ID, this.openType);
            settings.put(STORE_REPLACE_SOURCE_ID, this.replaceSource);
        }
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.openType = settings.getBoolean(STORE_OPEN_TYPE_ID);
            this.replaceSource = settings.getBoolean(STORE_REPLACE_SOURCE_ID);
        }
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.advancedComposite != null) {
            this.advancedComposite.dispose();
            this.advancedComposite = null;
            shell.setSize(shellSize.x, shellSize.y - this.advancedCompositeHeight);
        } else {
            this.advancedComposite = this.createAdvancedGroup(composite);
            if (-1 == this.advancedCompositeHeight) {
                Point groupSize = this.advancedComposite.computeSize(-1, -1, true);
                this.advancedCompositeHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.advancedCompositeHeight);
        }
        super.handleAdvancedButtonSelect();
    }

    private Composite createAdvancedGroup(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite groupComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        groupComposite.setLayout((Layout)layout);
        groupComposite.setLayoutData((Object)new GridData(784));
        groupComposite.setFont(font);
        Button openTypeCheckbox = new Button(groupComposite, 32);
        openTypeCheckbox.setText(Messages.SaveAsSubApplicationTypeAction_WizardPageOpenType);
        openTypeCheckbox.setSelection(this.openType);
        openTypeCheckbox.addListener(13, ev -> {
            boolean bl = this.openType = openTypeCheckbox.getSelection();
        });
        Button replaceSourceSubapp = new Button(groupComposite, 32);
        replaceSourceSubapp.setText(Messages.SaveAsSubappHandler_ReplaceDialogText);
        replaceSourceSubapp.setSelection(this.replaceSource);
        replaceSourceSubapp.addListener(13, ev -> {
            boolean bl = this.replaceSource = replaceSourceSubapp.getSelection();
        });
        return groupComposite;
    }
}

