/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class WorkingSetsDialog
extends TitleAreaDialog {
    protected TableViewer wsTableViewer;
    protected Text wsNameText;
    protected Image dlgTitleImage;
    private String selectedWorkingSet;
    public static final String resourceWorkingSetId = "org.eclipse.ui.resourceWorkingSetPage";

    public WorkingSetsDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(TeamUIMessages.WorkingSetsDialog_Title);
        this.setMessage(TeamUIMessages.WorkingSetsDialog_Message);
        Composite workingSetsComposite = (Composite)super.createDialogArea(parent);
        workingSetsComposite = new Composite(workingSetsComposite, 0);
        this.getShell().setText(TeamUIMessages.WorkingSetsDialog_TitleBar);
        Composite group = new Composite(workingSetsComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(group, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(TeamUIMessages.WorkingSetsDialog_Label);
        this.wsNameText = new Text(group, 2048);
        this.wsNameText.setLayoutData((Object)new GridData(4, 128, true, false));
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        workingSetsComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        workingSetsComposite.setLayoutData((Object)data);
        this.wsTableViewer = new TableViewer(workingSetsComposite, 2048);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 450;
        gd.heightHint = 250;
        this.wsTableViewer.getTable().setLayoutData((Object)gd);
        this.wsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.wsTableViewer.setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
        this.wsTableViewer.setInput((Object)PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        this.setupListeners();
        return parent;
    }

    protected void okPressed() {
        this.selectedWorkingSet = this.wsNameText.getText();
        if (this.selectedWorkingSet.equals("")) {
            this.setErrorMessage(TeamUIMessages.WorkingSetsDialog_ErrorMessage);
            return;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    void setupListeners() {
        this.wsTableViewer.addSelectionChangedListener(event -> {
            IStructuredSelection s = event.getStructuredSelection();
            Object obj = s.getFirstElement();
            if (obj instanceof IWorkingSet) {
                this.wsNameText.setText(((IWorkingSet)obj).getName());
            }
        });
        this.wsNameText.addModifyListener(e -> this.setErrorMessage(null));
    }

    public String getSelectedWorkingSet() {
        return this.selectedWorkingSet;
    }

    class WorkingSetLabelProvider
    extends LabelProvider {
        private Map<ImageDescriptor, Image> icons = new Hashtable<ImageDescriptor, Image>();

        public void dispose() {
            for (Image icon : this.icons.values()) {
                icon.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet workingSet = (IWorkingSet)object;
            ImageDescriptor imageDescriptor = workingSet.getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image icon = this.icons.get(imageDescriptor);
            if (icon == null) {
                icon = imageDescriptor.createImage();
                this.icons.put(imageDescriptor, icon);
            }
            return icon;
        }

        public String getText(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet workingSet = (IWorkingSet)object;
            return workingSet.getLabel();
        }
    }
}

