/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.navigator;

import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.Activator;
import org.eclipse.fordiac.ide.typemanagement.navigator.FBTypeComposedAdapterFactory;
import org.eclipse.fordiac.ide.typemanagement.util.FBTypeUtils;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class FBTypeLabelProvider
extends AdapterFactoryLabelProvider
implements IDescriptionProvider {
    public FBTypeLabelProvider() {
        super((AdapterFactory)FBTypeComposedAdapterFactory.getAdapterFactory());
    }

    public Image getImage(Object element) {
        if (element instanceof IFile) {
            return FBTypeLabelProvider.getImageForFile((IFile)element);
        }
        return super.getImage(element);
    }

    public static Image getImageForFile(IFile element) {
        Image image = null;
        if ("ADP".equalsIgnoreCase(element.getFileExtension())) {
            image = FordiacImage.ICON_ADAPTER.getImage();
        } else if ("SUB".equalsIgnoreCase(element.getFileExtension())) {
            image = FordiacImage.ICON_SUB_APP.getImage();
        } else if ("FBT".equalsIgnoreCase(element.getFileExtension())) {
            image = FBTypeLabelProvider.getImageForFBTypeFile(element);
        }
        if (image != null && FBTypeLabelProvider.fileHasProblems(element)) {
            return FordiacImage.getErrorOverlayImage((Image)image);
        }
        return image;
    }

    private static Image getImageForFBTypeFile(IFile element) {
        FBType type = FBTypeLabelProvider.getFBTypeFromFile(element);
        if (type instanceof BasicFBType) {
            return FordiacImage.ICON_BASIC_FB.getImage();
        }
        if (type instanceof CompositeFBType) {
            return FordiacImage.ICON_COMPOSITE_FB.getImage();
        }
        if (type instanceof ServiceInterfaceFBType) {
            return FordiacImage.ICON_SIFB.getImage();
        }
        return FBTypeLabelProvider.checkUnloadedFBType(element);
    }

    private static boolean fileHasProblems(IFile element) {
        IMarker[] problems = null;
        try {
            problems = element.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        return problems != null && problems.length > 0;
    }

    private static Image checkUnloadedFBType(IFile element) {
        Image image = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Scanner scanner = new Scanner(element.getContents());){
                if (scanner.findWithinHorizon("BasicFB", 0) != null) {
                    image = FordiacImage.ICON_BASIC_FB.getImage();
                } else {
                    scanner.reset();
                    image = scanner.findWithinHorizon("FBNetwork", 0) != null ? FordiacImage.ICON_COMPOSITE_FB.getImage() : FordiacImage.ICON_SIFB.getImage();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof IFile) {
            return FBTypeLabelProvider.getTextForFBFile((IFile)element);
        }
        return super.getText(element);
    }

    private static String getTextForFBFile(IFile element) {
        String text = null;
        if ("ADP".equalsIgnoreCase(element.getFileExtension()) || "FBT".equalsIgnoreCase(element.getFileExtension()) || "SUB".equalsIgnoreCase(element.getFileExtension())) {
            text = TypeLibrary.getTypeNameFromFile((IFile)element);
        }
        return text;
    }

    public String getDescription(Object anElement) {
        if (anElement instanceof IFile) {
            return FBTypeLabelProvider.getDescriptionForFBFile((IFile)anElement);
        }
        return null;
    }

    private static String getDescriptionForFBFile(IFile fbtFile) {
        FBType type = null;
        if ("FBT".equalsIgnoreCase(fbtFile.getFileExtension())) {
            type = FBTypeLabelProvider.getFBTypeFromFile(fbtFile);
        } else if ("ADP".equalsIgnoreCase(fbtFile.getFileExtension())) {
            type = FBTypeLabelProvider.getAdapterTypeForFile(fbtFile);
        }
        if (type != null) {
            return FBTypeLabelProvider.generateTypeDescriptionString(type);
        }
        return null;
    }

    private static String generateTypeDescriptionString(FBType type) {
        String description = String.valueOf(type.getName()) + ": ";
        if (type.getComment() != null) {
            description = String.valueOf(description) + type.getComment();
        }
        return description;
    }

    private static FBType getAdapterTypeForFile(IFile file) {
        PaletteEntry entry = FBTypeUtils.getPaletteEntryForFile(file);
        if (entry instanceof AdapterTypePaletteEntry) {
            return ((AdapterTypePaletteEntry)entry).getType().getAdapterFBType();
        }
        return null;
    }

    private static FBType getFBTypeFromFile(IFile file) {
        PaletteEntry entry = FBTypeUtils.getPaletteEntryForFile(file);
        if (entry instanceof FBTypePaletteEntry) {
            return ((FBTypePaletteEntry)entry).getFBType();
        }
        return null;
    }
}

