/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import org.eclipse.fordiac.ide.model.IdentifierVerifyer;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.NewElementPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class NewApplicationPage
extends NewElementPage {
    private Button openApplicationCheckbox;

    protected NewApplicationPage(String pageName) {
        super(pageName);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite container = (Composite)this.getControl();
        this.openApplicationCheckbox = new Button(container, 32);
        this.openApplicationCheckbox.setText(Messages.NewApplicationPage_OpenApplicationForEditing);
        this.openApplicationCheckbox.setSelection(true);
    }

    @Override
    public String validateElementName(String text) {
        if (!NewApplicationPage.isValidAppName(text, this.getSelectedSystem())) {
            return Messages.NewApplicationPage_ErrorMessageInvalidAppName;
        }
        return null;
    }

    public boolean getOpenApplication() {
        return this.openApplicationCheckbox.getSelection();
    }

    private static boolean isValidAppName(String appNameProposal, AutomationSystem selectedSystem) {
        if (!IdentifierVerifyer.isValidIdentifier((String)appNameProposal)) {
            return false;
        }
        for (Application app : selectedSystem.getApplication()) {
            if (!appNameProposal.equalsIgnoreCase(app.getName())) continue;
            return false;
        }
        return true;
    }
}

