/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.IExportFilter;
import org.eclipse.fordiac.ide.export.ui.Activator;
import org.eclipse.fordiac.ide.export.ui.Messages;
import org.eclipse.fordiac.ide.export.ui.wizard.ExportStatusMessageDialog;
import org.eclipse.fordiac.ide.export.ui.wizard.SelectFBTypesWizardPage;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;

public class FordiacExportWizard
extends Wizard
implements IExportWizard {
    private static final String FORDIAC_EXPORT_SECTION = "4DIAC_EXPORT_SECTION";
    private IStructuredSelection selection;
    private SelectFBTypesWizardPage page;

    public FordiacExportWizard() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.getSection(FORDIAC_EXPORT_SECTION) == null) {
            settings.addNewSection(FORDIAC_EXPORT_SECTION);
        }
        this.setDialogSettings(settings);
        this.setWindowTitle(Messages.FordiacExportWizard_LABEL_Window_Title);
    }

    public void addPages() {
        super.addPages();
        this.page = new SelectFBTypesWizardPage(Messages.FordiacExportWizard_WizardPage, this.selection);
        this.page.setDescription(Messages.FordiacExportWizard_DESCRIPTION_WizardPage);
        this.page.setTitle(Messages.FordiacExportWizard_TITLE_WizardPage);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IExportFilter filter;
        IConfigurationElement conf;
        this.page.saveWidgetValues();
        try {
            conf = this.page.getSelectedExportFilter();
            filter = (IExportFilter)conf.createExecutableExtension(Messages.FordiacExportWizard_Class);
        }
        catch (CoreException e) {
            MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
            msg.setMessage(String.valueOf(Messages.FordiacExportWizard_ERROR) + e.getMessage());
            msg.open();
            Activator.getDefault().logError(msg.getMessage(), (Exception)((Object)e));
            return true;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                List resources = FordiacExportWizard.this.page.getSelectedResources();
                String outputDirectory = FordiacExportWizard.this.page.getDirectory();
                SystemManager systemManager = SystemManager.INSTANCE;
                monitor.beginTask(MessageFormat.format(Messages.FordiacExportWizard_ExportingSelectedTypesUsingExporter, conf.getAttribute("name")), resources.size());
                for (Object object : resources) {
                    if (!(object instanceof IFile)) continue;
                    IFile file = (IFile)object;
                    Palette palette = systemManager.getPalette(file.getProject());
                    PaletteEntry entry = TypeLibrary.getPaletteEntryForFile((IFile)file, (Palette)palette);
                    LibraryElement type = entry.getType();
                    monitor.subTask(MessageFormat.format(Messages.FordiacExportWizard_ExportingType, entry.getLabel()));
                    try {
                        if (type != null) {
                            filter.export(file, outputDirectory, FordiacExportWizard.this.page.overwriteWithoutWarning(), type);
                        } else {
                            filter.export(file, outputDirectory, FordiacExportWizard.this.page.overwriteWithoutWarning());
                        }
                    }
                    catch (ExportException e) {
                        MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
                        msg.setMessage(String.valueOf(Messages.FordiacExportWizard_ERROR) + e.getMessage());
                        msg.open();
                    }
                    monitor.worked(1);
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, op);
        }
        catch (Exception e) {
            MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
            msg.setMessage(String.valueOf(Messages.FordiacExportWizard_ERROR) + e.getMessage());
            msg.open();
        }
        if (!filter.getErrors().isEmpty() || !filter.getWarnings().isEmpty()) {
            new ExportStatusMessageDialog(this.getShell(), filter.getWarnings(), filter.getErrors()).open();
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        this.selection = new StructuredSelection(selectedResources);
    }
}

