/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.ui.providers.AbstractCreationCommand;

public class CreateInternalVariableCommand
extends AbstractCreationCommand {
    private static final String DEFAULT_VAR_NAME = "INTERNALVAR1";
    private final DataType dataType;
    private final BasicFBType fbType;
    private VarDeclaration varDecl;
    private String name;
    private int index;

    public CreateInternalVariableCommand(BasicFBType fbType) {
        this(fbType, fbType.getInternalVars().size() - 1, null, null);
    }

    public CreateInternalVariableCommand(BasicFBType fbType, int index, String name, DataType dataType) {
        this.dataType = dataType != null ? dataType : DataTypeLibrary.getInstance().getType("BOOL");
        this.fbType = fbType;
        this.name = name != null ? name : DEFAULT_VAR_NAME;
        this.index = index;
    }

    public void execute() {
        this.varDecl = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        this.varDecl.setType(this.dataType);
        this.varDecl.setTypeName(this.dataType.getName());
        this.varDecl.setComment("Internal Variable");
        this.varDecl.setArraySize(0);
        Value value = LibraryElementFactory.eINSTANCE.createValue();
        value.setValue("");
        this.varDecl.setValue(value);
        this.redo();
        this.varDecl.setName(NameRepository.createUniqueName((INamedElement)this.varDecl, (String)this.name));
    }

    public void undo() {
        this.fbType.getInternalVars().remove((Object)this.varDecl);
    }

    public VarDeclaration getVarDecl() {
        return this.varDecl;
    }

    public void redo() {
        this.fbType.getInternalVars().add(this.index, (Object)this.varDecl);
    }

    public Object getCreatedElement() {
        return this.varDecl;
    }
}

