/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.resources;

import org.eclipse.egit.ui.internal.resources.IResourceState;
import org.eclipse.jgit.annotations.NonNull;

public class ResourceState
implements IResourceState {
    private boolean tracked;
    private boolean ignored;
    private boolean dirty;
    private boolean missing;
    @NonNull
    private IResourceState.StagingState staged = IResourceState.StagingState.NOT_STAGED;
    private boolean conflicts;
    private boolean assumeUnchanged;

    @Override
    public boolean isTracked() {
        return this.tracked;
    }

    @Override
    public boolean isIgnored() {
        return this.ignored;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }

    @Override
    public IResourceState.StagingState getStagingState() {
        return this.staged;
    }

    @Override
    public final boolean isStaged() {
        return this.staged != IResourceState.StagingState.NOT_STAGED;
    }

    @Override
    public boolean hasConflicts() {
        return this.conflicts;
    }

    @Override
    public boolean isAssumeUnchanged() {
        return this.assumeUnchanged;
    }

    @Override
    public final boolean hasUnstagedChanges() {
        return !this.isIgnored() && (!this.isTracked() || this.isDirty() || this.isMissing() || this.hasConflicts());
    }

    protected void setStagingState(@NonNull IResourceState.StagingState staged) {
        this.staged = staged;
    }

    protected void setConflicts(boolean conflicts) {
        this.conflicts = conflicts;
    }

    protected void setTracked(boolean tracked) {
        this.tracked = tracked;
    }

    protected void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected void setMissing(boolean missing) {
        this.missing = missing;
    }

    protected void setAssumeUnchanged(boolean assumeUnchanged) {
        this.assumeUnchanged = assumeUnchanged;
    }
}

