/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.commands.ConnectThroughCommand;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.editparts.InterfaceEditPartForFBNetwork;
import org.eclipse.fordiac.ide.model.commands.create.LinkConstraints;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConnectThroughHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ConnectThroughCommand cmd;
        FBNetworkEditor editor = (FBNetworkEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List<IInterfaceElement> ies = ConnectThroughHandler.checkSelection(selection);
        if (!ies.isEmpty() && (cmd = new ConnectThroughCommand(ies.get(0), ies.get(1))).canExecute()) {
            editor.getCommandStack().execute((Command)cmd);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(!ConnectThroughHandler.checkSelection((ISelection)selection).isEmpty());
    }

    private static List<IInterfaceElement> checkSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)selection;
            List<IInterfaceElement> ieList = structSel.toList().stream().filter(val -> val instanceof InterfaceEditPartForFBNetwork).map(val -> ((InterfaceEditPartForFBNetwork)((Object)((Object)val))).getModel()).collect(Collectors.toList());
            ieList.sort((arg0, arg1) -> {
                if (arg0.isIsInput() && !arg1.isIsInput()) {
                    return -1;
                }
                if (arg1.isIsInput() && !arg0.isIsInput()) {
                    return 1;
                }
                return 0;
            });
            if (ieList.size() == 2 && ConnectThroughHandler.checkSelectedIEs((IInterfaceElement)ieList.get(0), (IInterfaceElement)ieList.get(1))) {
                return ieList;
            }
        }
        return Collections.emptyList();
    }

    private static boolean checkSelectedIEs(IInterfaceElement element1, IInterfaceElement element2) {
        if (!element2.isIsInput() && element1.getClass().equals(element2.getClass()) && !element1.getInputConnections().isEmpty() && !element2.getOutputConnections().isEmpty()) {
            if (element1 instanceof VarDeclaration) {
                return LinkConstraints.typeCheck((VarDeclaration)((VarDeclaration)element1), (VarDeclaration)((VarDeclaration)element2));
            }
            return true;
        }
        return false;
    }
}

