/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.commands.ListFBCreateCommand;
import org.eclipse.fordiac.ide.application.commands.PasteCommand;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.commands.change.SetPositionCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateSubAppInstanceCommand;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.util.dnd.TransferDataSelectionOfFb;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class FBNetworkXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private ZoomManager zoomManager;

    public void setHost(EditPart host) {
        super.setHost(host);
        this.zoomManager = ((ScalableFreeformRootEditPart)this.getHost().getRoot()).getZoomManager();
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new ModifiedNonResizeableEditPolicy();
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (child.getModel() instanceof PositionableElement && constraint instanceof Rectangle) {
            return new SetPositionCommand((PositionableElement)child.getModel(), request, (Rectangle)constraint);
        }
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (request != null) {
            Object childClass = request.getNewObjectType();
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            if (this.getHost().getModel() instanceof FBNetwork) {
                FBNetwork fbNetwork = (FBNetwork)this.getHost().getModel();
                if (childClass instanceof FBTypePaletteEntry) {
                    FBTypePaletteEntry type = (FBTypePaletteEntry)childClass;
                    return new FBCreateCommand(type, fbNetwork, constraint.getLocation().x, constraint.getLocation().y);
                }
                if (childClass instanceof FBTypePaletteEntry[]) {
                    FBTypePaletteEntry[] type = (FBTypePaletteEntry[])childClass;
                    return new ListFBCreateCommand(type, fbNetwork, constraint.getLocation().x, constraint.getLocation().y);
                }
                if (childClass instanceof SubApplicationTypePaletteEntry) {
                    SubApplicationTypePaletteEntry type = (SubApplicationTypePaletteEntry)request.getNewObjectType();
                    return new CreateSubAppInstanceCommand(type, fbNetwork, constraint.getLocation().x, constraint.getLocation().y);
                }
                if (childClass instanceof TransferDataSelectionOfFb[]) {
                    TransferDataSelectionOfFb[] type = (TransferDataSelectionOfFb[])childClass;
                    return new ListFBCreateCommand(type, fbNetwork, constraint.getLocation().x, constraint.getLocation().y);
                }
            }
        }
        return null;
    }

    protected Command getAddCommand(Request generic) {
        return null;
    }

    protected Command getCloneCommand(ChangeBoundsRequest request) {
        List elements = request.getEditParts().stream().map(n -> ((EditPart)n).getModel()).collect(Collectors.toList());
        Point scaledPoint = request.getMoveDelta().getScaled(1.0 / this.zoomManager.getZoom());
        return new PasteCommand(elements, (FBNetwork)this.getHost().getModel(), scaledPoint.x, scaledPoint.y);
    }
}

