/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.wizards;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.ApplicationPlugin;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.commands.CommandUtil;
import org.eclipse.fordiac.ide.application.wizards.SaveAsSubappWizardPage;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.fordiac.ide.typemanagement.util.FBTypeUtils;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class SaveAsSubappWizard
extends Wizard {
    private static final String SUBAPP_SECTION = "SUBAPP_SECTION";
    private final SubApp subApp;
    private SaveAsSubappWizardPage newFilePage;
    private PaletteEntry entry = null;

    public SaveAsSubappWizard(SubApp subApp) {
        this.setWindowTitle(Messages.SaveAsSubApplicationTypeAction_WizardTitle);
        this.subApp = subApp;
        this.setupDiagramSettings();
    }

    private void setupDiagramSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.getSection(SUBAPP_SECTION) == null) {
            settings.addNewSection(SUBAPP_SECTION);
        }
        this.setDialogSettings(settings);
    }

    public PaletteEntry getEntry() {
        return this.entry;
    }

    public void addPages() {
        IProject project = this.getSystem().getProject();
        StructuredSelection selection = new StructuredSelection((Object)project);
        this.newFilePage = new SaveAsSubappWizardPage(Messages.SaveAsSubApplicationTypeAction_WizardPageName, (IStructuredSelection)selection);
        this.newFilePage.setFileName(this.subApp.getName());
        this.addPage((IWizardPage)this.newFilePage);
    }

    private AutomationSystem getSystem() {
        return this.subApp.getSubAppNetwork().getAutomationSystem();
    }

    public boolean performFinish() {
        boolean perform = true;
        this.newFilePage.saveWidgetValues();
        IFile targetFile = this.getTargetTypeFile();
        if (targetFile.exists()) {
            perform = this.askOverwrite();
        }
        if (perform) {
            if (this.createSubAppTemplateCopy()) {
                this.entry = this.getPalletEntry();
                LibraryElement type = this.entry.getType();
                type.setName(TypeLibrary.getTypeNameFromFile((IFile)this.entry.getFile()));
                TypeManagementPreferencesHelper.setupIdentification((LibraryElement)type);
                TypeManagementPreferencesHelper.setupVersionInfo((LibraryElement)type);
                this.performTypeSetup((SubAppType)type);
                AbstractTypeExporter.saveType((PaletteEntry)this.entry);
                this.entry.setType(type);
                if (this.newFilePage.getOpenType()) {
                    SaveAsSubappWizard.openTypeEditor(this.entry);
                }
                if (this.newFilePage.getReplaceSoure()) {
                    this.replaceWithType(this.entry);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean askOverwrite() {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.SaveAsSubApplicationTypeAction_WizardOverrideTitle, (String)Messages.SaveAsSubApplicationTypeAction_WizardOverrideMessage);
    }

    private boolean createSubAppTemplateCopy() {
        String templateFolderPath = Platform.getInstallLocation().getURL().getFile();
        File templateFolder = new File(String.valueOf(templateFolderPath) + File.separatorChar + "template");
        File[] fileList = templateFolder.listFiles();
        if (fileList != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName().toUpperCase();
                if (fileName.endsWith("SUB")) {
                    IFile targetTypeFile = this.getTargetTypeFile();
                    try {
                        ImportUtils.copyFile((File)file, (IFile)targetTypeFile);
                        return true;
                    }
                    catch (IOException | CoreException e) {
                        ApplicationPlugin.getDefault().logError(e.getMessage(), (Exception)e);
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private IFile getTargetTypeFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.newFilePage.getContainerFullPath() + File.separator + this.newFilePage.getFileName() + ".SUB"));
    }

    private PaletteEntry getPalletEntry() {
        Palette palette = this.getSystem().getPalette();
        IFile targetTypeFile = this.getTargetTypeFile();
        PaletteEntry newEntry = FBTypeUtils.getPaletteEntryForFile((IFile)targetTypeFile);
        if (newEntry == null) {
            TypeLibrary.refreshPalette((Palette)palette);
            newEntry = FBTypeUtils.getPaletteEntryForFile((IFile)targetTypeFile);
        }
        return newEntry;
    }

    private static void openTypeEditor(PaletteEntry entry) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(entry.getFile().getName());
        EditorUtils.openEditor((IEditorInput)new FileEditorInput(entry.getFile()), (String)desc.getId());
    }

    private void replaceWithType(PaletteEntry entry) {
        CommandUtil.closeOpenedSubApp(this.subApp.getSubAppNetwork());
        SystemManager.INSTANCE.getCommandStack(this.getSystem()).execute((Command)new UpdateFBTypeCommand((FBNetworkElement)this.subApp, entry));
    }

    private void performTypeSetup(SubAppType type) {
        this.performInterfaceSetup(type);
        type.setFBNetwork(FBNetworkHelper.copyFBNetWork((FBNetwork)this.subApp.getSubAppNetwork(), (InterfaceList)type.getInterfaceList()));
    }

    private void performInterfaceSetup(SubAppType type) {
        InterfaceList interfaceList = (InterfaceList)EcoreUtil.copy((EObject)this.subApp.getInterface());
        type.setInterfaceList(interfaceList);
    }
}

