/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.FBNetworkExporter;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.OtherAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.libraryElement.TextAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

class FbtExporter
extends AbstractTypeExporter {
    private static final Pattern CDATA_END_PATTERN = Pattern.compile("\\]\\]>");

    FbtExporter(FBTypePaletteEntry entry) {
        super(entry.getFBType());
    }

    @Override
    protected String getRootTag() {
        return "FBType";
    }

    @Override
    protected void createTypeSpecificXMLEntries() throws XMLStreamException {
        if (this.getType() instanceof CompositeFBType) {
            new FBNetworkExporter(this).createFBNetworkElement(((CompositeFBType)this.getType()).getFBNetwork());
        } else if (this.getType() instanceof BasicFBType) {
            this.addBasicFB((BasicFBType)this.getType());
        } else if (this.getType() instanceof SimpleFBType) {
            this.addSimpleFB((SimpleFBType)this.getType());
        }
    }

    private void addBasicFB(BasicFBType type) throws XMLStreamException {
        this.addStartElement("BasicFB");
        this.addVarList((List<VarDeclaration>)type.getInternalVars(), "InternalVars");
        this.addECC(type.getECC());
        for (Algorithm alg : type.getAlgorithm()) {
            this.addAlgorithm(alg);
        }
        this.addEndElement();
    }

    private void addOtherAlgorithm(OtherAlgorithm algorithm) throws XMLStreamException {
        this.addStartElement("Other");
        this.getWriter().writeAttribute("Language", algorithm.getLanguage() != null ? algorithm.getLanguage() : "");
        this.writeTextAlgorithmText(algorithm);
        this.addInlineEndElement();
    }

    private void writeTextAlgorithmText(TextAlgorithm algorithm) throws XMLStreamException {
        if (algorithm.getText() != null) {
            Matcher endPatternMatcher = CDATA_END_PATTERN.matcher(algorithm.getText());
            int currentPosition = 0;
            if (endPatternMatcher.find()) {
                do {
                    this.getWriter().writeCData(algorithm.getText().substring(currentPosition, endPatternMatcher.start()));
                    this.getWriter().writeCharacters("]]>");
                    currentPosition = endPatternMatcher.end();
                } while (endPatternMatcher.find());
                if (currentPosition < algorithm.getText().length()) {
                    this.getWriter().writeCData(algorithm.getText().substring(currentPosition));
                }
            } else {
                this.getWriter().writeCData(algorithm.getText());
            }
        } else {
            this.getWriter().writeCharacters("");
        }
    }

    private void addSTAlgorithm(STAlgorithm algorithm) throws XMLStreamException {
        this.addStartElement("ST");
        this.writeTextAlgorithmText(algorithm);
        this.addInlineEndElement();
    }

    private void addECC(ECC ecc) throws XMLStreamException {
        this.addStartElement("ECC");
        if (ecc != null) {
            this.addECStates((List<ECState>)ecc.getECState(), ecc.getStart());
            for (ECTransition transition : ecc.getECTransition()) {
                this.createTransitionEntry(transition);
            }
        }
        this.addEndElement();
    }

    private void createTransitionEntry(ECTransition transition) throws XMLStreamException {
        this.addEmptyStartElement("ECTransition");
        this.getWriter().writeAttribute("Source", transition.getSource().getName());
        this.getWriter().writeAttribute("Destination", transition.getDestination().getName());
        this.getWriter().writeAttribute("Condition", transition.getConditionText());
        if (transition.getComment() != null) {
            this.getWriter().writeAttribute("Comment", transition.getComment());
        }
        this.addXYAttributes(transition);
    }

    private void addECStates(List<ECState> states, ECState startState) throws XMLStreamException {
        this.createECState(startState);
        for (ECState state : states) {
            if (state.equals(startState)) continue;
            this.createECState(state);
        }
    }

    private void createECState(ECState state) throws XMLStreamException {
        this.addStartElement("ECState");
        this.addNameAttribute(state.getName());
        this.addCommentAttribute(state);
        this.addXYAttributes(state);
        this.addECActions((List<ECAction>)state.getECAction());
        this.addEndElement();
    }

    private void addECActions(List<ECAction> actions) throws XMLStreamException {
        for (ECAction action : actions) {
            this.addEmptyStartElement("ECAction");
            if (action.getAlgorithm() != null) {
                this.getWriter().writeAttribute("Algorithm", action.getAlgorithm().getName());
            }
            if (action.getOutput() == null) continue;
            this.getWriter().writeAttribute("Output", action.getOutput().getName());
        }
    }

    private void addSimpleFB(SimpleFBType type) throws XMLStreamException {
        this.addStartElement("SimpleFB");
        this.addVarList((List<VarDeclaration>)type.getInternalVars(), "InternalVars");
        this.addAlgorithm(type.getAlgorithm());
        this.addEndElement();
    }

    private void addAlgorithm(Algorithm algorithm) throws XMLStreamException {
        this.addStartElement("Algorithm");
        this.addNameAttribute(algorithm.getName());
        this.addCommentAttribute(algorithm);
        if (algorithm instanceof STAlgorithm) {
            this.addSTAlgorithm((STAlgorithm)algorithm);
        } else if (algorithm instanceof OtherAlgorithm) {
            this.addOtherAlgorithm((OtherAlgorithm)algorithm);
        }
        this.addEndElement();
    }
}

