/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;

@Beta
public abstract class AbstractFoldingTest
extends AbstractEditorTest {
    @Inject
    @Extension
    protected FileExtensionProvider _fileExtensionProvider;
    @Inject
    @Extension
    protected IFoldingRegionProvider _iFoldingRegionProvider;

    public String b() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[>");
        return _builder.toString();
    }

    public String e() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<]");
        return _builder.toString();
    }

    public void testFoldingRegions(CharSequence it) {
        this.foldingRegionsArePresent(this.openInEditor(this.dslFile(it)), it);
    }

    protected IFile dslFile(CharSequence text) {
        try {
            boolean _not;
            IFile _xblockexpression = null;
            IFile file = IResourcesSetupUtil.createFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), this.getContent(text));
            IProject project = file.getProject();
            boolean _hasNature = project.hasNature("org.eclipse.xtext.ui.shared.xtextNature");
            boolean bl = _not = !_hasNature;
            if (_not) {
                IResourcesSetupUtil.addNature(project, "org.eclipse.xtext.ui.shared.xtextNature");
            }
            _xblockexpression = file;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getProjectName() {
        return "FoldingTestProject";
    }

    protected String getFileName() {
        return "folding";
    }

    protected String getFileExtension() {
        return this._fileExtensionProvider.getPrimaryFileExtension();
    }

    protected String getContent(CharSequence text) {
        return text.toString().replaceAll(Pattern.quote(this.b()), "").replaceAll(Pattern.quote(this.e()), "");
    }

    protected IXtextDocument openInEditor(IFile dslFile) {
        try {
            IXtextDocument _xblockexpression = null;
            IXtextDocument document = this.openEditor(dslFile).getDocument();
            Assert.assertNotNull((Object)document);
            _xblockexpression = document;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void foldingRegionsArePresent(IXtextDocument document, CharSequence expected) {
        String actual = this.insertFoldingRegionMarkers(document);
        Assert.assertEquals((Object)expected.toString().trim(), (Object)actual);
    }

    protected String insertFoldingRegionMarkers(IXtextDocument document) {
        try {
            String _xblockexpression = null;
            String lineSeparator = System.lineSeparator();
            List lines = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)document.get().split(lineSeparator))));
            Collection _foldingRegions = this._iFoldingRegionProvider.getFoldingRegions(document);
            for (FoldedPosition foldingRegion : _foldingRegions) {
                int startLine = document.getLineOfOffset(foldingRegion.offset);
                String _b = this.b();
                String _get = (String)lines.get(startLine);
                String _plus = String.valueOf(_b) + _get;
                lines.set(startLine, _plus);
                int _lineOfOffset = document.getLineOfOffset(foldingRegion.offset + foldingRegion.length);
                int endLine = _lineOfOffset - 1;
                String _get_1 = (String)lines.get(endLine);
                String _e = this.e();
                String _plus_1 = String.valueOf(_get_1) + _e;
                lines.set(endLine, _plus_1);
            }
            _xblockexpression = IterableExtensions.join((Iterable)lines, (CharSequence)lineSeparator);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

