/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util;

import java.util.Random;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.util.ColorManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;

public final class ColorHelper {
    private static final double MAX_RGB_VALUE = 255.0;
    private static final float VALUE_MULTIPLIER = 0.6f;
    private static final double GOLDEN_RATIO_CONJUGATE = 0.618033988749895;
    private static Random rand = new Random(System.currentTimeMillis());
    private static double h = rand.nextDouble();

    private ColorHelper() {
    }

    public static org.eclipse.swt.graphics.Color lighter(org.eclipse.swt.graphics.Color original) {
        return ColorHelper.transformColorLightness(original, 1.6666666004392863);
    }

    public static org.eclipse.swt.graphics.Color transformColorLightness(org.eclipse.swt.graphics.Color original, double scale) {
        if (original == null) {
            return null;
        }
        double[] hsl = ColorHelper.rgbToHSL(original.getRGB());
        hsl[2] = Math.min(1.0, hsl[2] * scale);
        return ColorManager.getColor(ColorHelper.hslToRGB(hsl));
    }

    public static org.eclipse.swt.graphics.Color darker(org.eclipse.swt.graphics.Color original) {
        return ColorHelper.transformColorLightness(original, 0.6f);
    }

    public static double[] rgbToHSL(RGB rgb) {
        double r = (double)rgb.red / 255.0;
        double g = (double)rgb.green / 255.0;
        double b = (double)rgb.blue / 255.0;
        double max = Math.max(Math.max(r, g), b);
        double min = Math.min(Math.min(r, g), b);
        double[] hsl = new double[]{0.0, 0.0, (max + min) / 2.0};
        if (max != min) {
            double delta = max - min;
            hsl[1] = hsl[2] <= 0.5 ? delta / (max + min) : delta / (2.0 - (max + min));
            if (Math.abs(max - r) <= Double.MIN_VALUE) {
                hsl[0] = (g - b) / delta;
            } else if (Math.abs(max - g) <= Double.MIN_VALUE) {
                hsl[0] = 2.0 + (b - r) / delta;
            } else if (Math.abs(max - b) <= Double.MIN_VALUE) {
                hsl[0] = 4.0 + (r - g) / delta;
            }
            hsl[0] = hsl[0] * 60.0;
            if (hsl[0] < 0.0) {
                hsl[0] = hsl[0] + 360.0;
            }
        }
        return hsl;
    }

    public static RGB hslToRGB(double[] hsl) {
        RGB retVal = new RGB(0, 0, 0);
        if (hsl[1] == 0.0) {
            if (hsl[0] == 0.0) {
                retVal.green = retVal.blue = (int)(hsl[2] * 255.0);
                retVal.red = retVal.blue;
            } else {
                SWT.error((int)5);
            }
        } else {
            double m2 = hsl[2] <= 0.5 ? hsl[2] * (1.0 + hsl[1]) : hsl[2] + hsl[1] - hsl[2] * hsl[1];
            double m1 = 2.0 * hsl[2] - m2;
            retVal.red = ColorHelper.hslValue(m1, m2, hsl[0] + 120.0);
            retVal.green = ColorHelper.hslValue(m1, m2, hsl[0]);
            retVal.blue = ColorHelper.hslValue(m1, m2, hsl[0] - 120.0);
        }
        return retVal;
    }

    private static int hslValue(double m1, double m2, double hue) {
        double retVal = m1;
        if (hue > 360.0) {
            hue -= 360.0;
        } else if (hue < 0.0) {
            hue += 360.0;
        }
        if (hue < 60.0) {
            retVal = m1 + (m2 - m1) * hue / 60.0;
        } else if (hue < 180.0) {
            retVal = m2;
        } else if (hue < 240.0) {
            retVal = m1 + (m2 - m1) * (240.0 - hue) / 60.0;
        }
        return (int)(255.0 * retVal);
    }

    public static Color createRandomColor() {
        RGB rgbColor = ColorHelper.createRandomColor(0.6f, 0.85f);
        Color color = LibraryElementFactory.eINSTANCE.createColor();
        color.setRed(rgbColor.red);
        color.setGreen(rgbColor.green);
        color.setBlue(rgbColor.blue);
        return color;
    }

    public static RGB createRandomColor(float s, float v) {
        h += 0.618033988749895;
        s = (float)((double)s + (rand.nextDouble() * 0.5 - 0.25));
        v = (float)((double)v + (rand.nextDouble() * 0.2 - 0.1));
        return new RGB((float)((h %= 1.0) * 360.0), s, v);
    }

    public static Color getStartingColor() {
        Color color = LibraryElementFactory.eINSTANCE.createColor();
        color.setRed(255);
        color.setGreen(190);
        color.setBlue(111);
        return color;
    }
}

