/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fortelauncher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.fortelauncher.Activator;
import org.eclipse.fordiac.ide.fortelauncher.Messages;
import org.eclipse.fordiac.ide.runtime.IRuntimeLauncher;
import org.eclipse.fordiac.ide.runtime.LaunchParameter;
import org.eclipse.fordiac.ide.runtime.LaunchRuntimeException;
import org.eclipse.fordiac.ide.runtime.LaunchRuntimeUtils;

public class ForteLauncher
implements IRuntimeLauncher {
    private final List<LaunchParameter> params = new ArrayList<LaunchParameter>();

    public ForteLauncher() {
        this.setParam(Messages.ForteLauncher_LABEL_PortParam, "61499");
    }

    public String getName() {
        return "Local FORTE";
    }

    public void launch() throws LaunchRuntimeException {
        try {
            int port = Integer.parseInt(this.params.get(0).getValue());
            if (port < 1024 || port > 65535) {
                throw new NumberFormatException();
            }
            String runtimePath = this.getRuntimePath();
            LaunchRuntimeUtils.startRuntime((String)"FORTE", (String)runtimePath, (String)new File(runtimePath).getParentFile().getAbsolutePath(), (String)("-c localhost:" + this.params.get(0).getValue()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new LaunchRuntimeException(Messages.ForteLauncher_ERROR_WrongPort);
        }
        catch (Exception ex) {
            Activator.getDefault().logError(Messages.ForteLauncher_ERROR_CouldNotLaunchFORTE, ex);
        }
    }

    public String getRuntimePath() {
        return Activator.getDefault().getPreferenceStore().getString("pathPreference");
    }

    public int getNumParameters() {
        return this.params.size();
    }

    public List<LaunchParameter> getParams() {
        return this.params;
    }

    public final LaunchParameter setParam(String name, String value) {
        int i = 0;
        while (i < this.params.size()) {
            if (this.params.get(i).getName().equals(name)) {
                this.params.get(i).setValue(value);
                return this.params.get(i);
            }
            ++i;
        }
        LaunchParameter param = new LaunchParameter();
        param.setName(name);
        param.setValue(value);
        this.params.add(param);
        return param;
    }

    public String getPathPreferenceSettingPageID() {
        return "org.eclipse.fordiac.ide.fortelauncher.preferences.FortePreferencePage";
    }
}

