/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.resourceediting.editparts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkEditPart;
import org.eclipse.fordiac.ide.application.policies.FBNetworkXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.resourceediting.editparts.VirtualIO;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.swt.graphics.Point;

public class FBNetworkContainerEditPart
extends FBNetworkEditPart {
    private Adapter contentAdapter;
    private final Map<IInterfaceElement, VirtualIO> virutalIOMapping = new HashMap<IInterfaceElement, VirtualIO>();

    protected Adapter getContentAdapter() {
        if (this.contentAdapter == null) {
            this.contentAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    Object feature = notification.getFeature();
                    if (LibraryElementPackage.eINSTANCE.getFBNetwork_NetworkElements().equals(feature) || LibraryElementPackage.eINSTANCE.getIInterfaceElement_InputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getIInterfaceElement_OutputConnections().equals(feature)) {
                        FBNetworkContainerEditPart.this.refreshChildren();
                        FBNetworkContainerEditPart.this.refreshVisuals();
                    }
                }
            };
        }
        return this.contentAdapter;
    }

    public VirtualIO getVirtualIOElement(IInterfaceElement element) {
        return this.virutalIOMapping.get(element);
    }

    protected List getModelChildren() {
        this.virutalIOMapping.clear();
        ArrayList children = new ArrayList(super.getModelChildren());
        ArrayList<VirtualIO> interfaceElements = new ArrayList<VirtualIO>();
        for (Object object : children) {
            FBNetworkElement fbNetworkelement;
            if (!(object instanceof FBNetworkElement) || !(fbNetworkelement = (FBNetworkElement)object).isMapped()) continue;
            FBNetworkElement opposite = fbNetworkelement.getOpposite();
            for (IInterfaceElement ie : opposite.getInterface().getAllInterfaceElements()) {
                EList connections = ie.isIsInput() ? ie.getInputConnections() : ie.getOutputConnections();
                for (Connection connection : connections) {
                    VirtualIO vIO;
                    if (!connection.isBrokenConnection() || (vIO = this.createVirtualIOElement(fbNetworkelement, ie.getName())) == null) continue;
                    interfaceElements.add(vIO);
                }
            }
        }
        children.addAll(interfaceElements);
        return children;
    }

    private VirtualIO createVirtualIOElement(FBNetworkElement fbNetworkelement, String name) {
        IInterfaceElement ie = fbNetworkelement.getInterfaceElement(name);
        if (ie != null) {
            VirtualIO vIO = new VirtualIO(ie);
            this.virutalIOMapping.put(ie, vIO);
            return vIO;
        }
        return null;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FBNetworkXYLayoutEditPolicy());
    }

    public void performRequest(Request req) {
        Command cmd = this.getCommand(req);
        if (cmd != null && cmd.canExecute()) {
            this.getViewer().getEditDomain().getCommandStack().execute(cmd);
        }
        super.performRequest(req);
    }

    protected void refreshVisuals() {
        Point p = this.getParent().getViewer().getControl().getSize();
        Rectangle rect = new Rectangle(0, 0, p.x, p.y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rect);
        super.refreshVisuals();
    }
}

