/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.resourceediting.editparts;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.editparts.InterfaceEditPartForFBNetwork;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.resourceediting.editparts.FBNetworkContainerEditPart;
import org.eclipse.fordiac.ide.resourceediting.editparts.InterfaceEditPartForResourceFBs;
import org.eclipse.fordiac.ide.resourceediting.editparts.VirtualIO;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Font;

public class VirtualInOutputEditPart
extends AbstractViewEditPart
implements NodeEditPart {
    public void activate() {
        super.activate();
        this.updatePos();
    }

    protected Adapter createContentAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                VirtualInOutputEditPart.this.refreshSourceConnections();
                VirtualInOutputEditPart.this.refreshTargetConnections();
                VirtualInOutputEditPart.this.refreshVisuals();
                VirtualInOutputEditPart.this.refreshTooltip();
            }
        };
    }

    private void refreshTooltip() {
        this.getFigure().setToolTip((IFigure)new VirtualIOTooltipFigure());
    }

    private void updatePos() {
        if (this.getParent() instanceof FBNetworkContainerEditPart) {
            IInterfaceElement element = this.getIInterfaceElement();
            Object o = this.getViewer().getEditPartRegistry().get(element);
            if (o instanceof InterfaceEditPartForResourceFBs) {
                this.updatePos((InterfaceEditPartForResourceFBs)((Object)o));
            }
        }
    }

    void updatePos(InterfaceEditPartForFBNetwork referencedEditPart) {
        String label = ((Label)this.getFigure()).getText();
        Rectangle bounds = referencedEditPart.getFigure().getBounds();
        int x = this.isInput() ? bounds.x - 20 - FigureUtilities.getTextWidth((String)label, (Font)this.getFigure().getFont()) : bounds.x + bounds.width + 1;
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(x, bounds.y, -1, -1));
    }

    public VirtualIO getModel() {
        return (VirtualIO)super.getModel();
    }

    public boolean isInput() {
        return this.getIInterfaceElement().isIsInput();
    }

    private IInterfaceElement getIInterfaceElement() {
        return this.getModel().getReferencedInterfaceElement();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", null);
    }

    public boolean understandsRequest(Request request) {
        if (request.getType() == "move") {
            return false;
        }
        if (request.getType() == "direct edit" || request.getType() == "open") {
            return false;
        }
        return super.understandsRequest(request);
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            return;
        }
        super.performRequest(request);
    }

    protected IFigure createFigureForModel() {
        return new VirtualInputOutputFigure();
    }

    public INamedElement getINamedElement() {
        return this.getModel().getReferencedInterfaceElement();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    public Label getNameLabel() {
        return null;
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        return null;
    }

    protected void refreshName() {
    }

    private class VirtualIOTooltipFigure
    extends Figure {
        public VirtualIOTooltipFigure() {
            this.setLayoutManager((LayoutManager)new BorderLayout());
            Figure leftCol = new Figure();
            Figure rightCol = new Figure();
            leftCol.setLayoutManager((LayoutManager)new ToolbarLayout());
            rightCol.setLayoutManager((LayoutManager)new ToolbarLayout());
            this.add((IFigure)leftCol, BorderLayout.LEFT);
            this.add((IFigure)rightCol, BorderLayout.CENTER);
            this.add((IFigure)new Label(VirtualInOutputEditPart.this.getIInterfaceElement().getName()), BorderLayout.TOP);
            FBNetworkElement fbNetElement = VirtualInOutputEditPart.this.getIInterfaceElement().getFBNetworkElement();
            if (fbNetElement == null) {
                return;
            }
            if (fbNetElement.getResource() == null) {
                return;
            }
            Resource res = fbNetElement.getResource();
            if (res == null) {
                return;
            }
            Device dev = res.getDevice();
            if (dev == null) {
                return;
            }
            this.add((IFigure)new Label(String.valueOf(dev.getName()) + "." + res.getName() + "." + fbNetElement.getName() + "." + VirtualInOutputEditPart.this.getIInterfaceElement().getName()), BorderLayout.TOP);
        }
    }

    private class VirtualInputOutputFigure
    extends Label {
        public VirtualInputOutputFigure() {
            this.setOpaque(false);
            if (!VirtualInOutputEditPart.this.isInput()) {
                this.setIcon(FordiacImage.ICON_LINK_OUTPUT.getImage());
                this.setLabelAlignment(1);
                this.setTextAlignment(1);
            } else {
                this.setIcon(FordiacImage.ICON_LINK_INPUT.getImage());
                this.setLabelAlignment(4);
                this.setTextAlignment(4);
            }
            this.setToolTip((IFigure)new VirtualIOTooltipFigure());
            this.setSize(-1, -1);
        }
    }
}

