/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.actions;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.fordiac.ide.fbtypeeditor.Messages;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.typemanagement.wizards.NewFBTypeWizard;
import org.eclipse.fordiac.ide.typemanagement.wizards.NewFBTypeWizardPage;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPart;

public abstract class CreateFromNewAdapterAction
extends WorkbenchPartAction {
    private FBType fbType;
    private PaletteEntry paletteEntry;

    protected FBType getFbType() {
        return this.fbType;
    }

    CreateFromNewAdapterAction(IWorkbenchPart part, FBType fbType) {
        super(part);
        this.setText(Messages.CreateFromNewAdapterAction_NewAdapter);
        this.fbType = fbType;
    }

    protected boolean calculateEnabled() {
        return this.fbType != null;
    }

    public void run() {
        PaletteEntry entry;
        NewFBTypeWizard wizard = new NewFBTypeWizard(){

            protected NewFBTypeWizardPage createNewFBTypeWizardPage() {
                return new NewFBTypeWizardPage(CreateFromNewAdapterAction.this.getSelection()){

                    protected FileFilter createTemplatesFileFilter() {
                        return new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return pathname.getName().toUpperCase().endsWith(".ADP");
                            }
                        };
                    }
                };
            }
        };
        WizardDialog dialog = new WizardDialog(this.getWorkbenchPart().getSite().getShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0 && (entry = wizard.getPaletteEntry()) instanceof AdapterTypePaletteEntry) {
            this.execute(this.getCreationCommand((AdapterTypePaletteEntry)entry));
        }
    }

    private IStructuredSelection getSelection() {
        if (this.paletteEntry != null) {
            return new StructuredSelection((Object)this.paletteEntry.getFile().getParent());
        }
        return new StructuredSelection();
    }

    protected abstract Command getCreationCommand(AdapterTypePaletteEntry var1);

    public void setPaletteEntry(PaletteEntry paletteEntry) {
        this.paletteEntry = paletteEntry;
    }
}

