/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.swt.graphics.Font;

public class HideableConnection
extends PolylineConnection {
    public static final int BEND_POINT_BEVEL_SIZE = 5;
    private boolean hidden = false;
    private String label = "";
    private Rectangle moveRect = new Rectangle();
    private Connection model;

    public void setModel(Connection newModel) {
        this.model = newModel;
    }

    public Connection getModel() {
        return this.model;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    protected void outlineShape(Graphics g) {
        if (this.isHidden()) {
            int[] startLine = new int[]{this.getStart().x, this.getStart().y, this.getStart().x + 20, this.getStart().y};
            int[] endLine = new int[]{this.getEnd().x, this.getEnd().y, this.getEnd().x - 20, this.getEnd().y};
            g.drawPolyline(startLine);
            g.drawPolyline(endLine);
            Dimension dim = FigureUtilities.getTextExtents((String)this.label, (Font)g.getFont());
            g.drawText(this.label, new Point(this.getEnd().x - dim.width - 25, this.getEnd().y - dim.height / 2));
            this.moveRect.x = this.getEnd().x - dim.width - 25;
            this.moveRect.y = this.getEnd().y - dim.height / 2;
            this.moveRect.width = 5;
            this.moveRect.height = 5;
        } else {
            this.drawBeveledPolyline(g);
        }
    }

    private void drawBeveledPolyline(Graphics g) {
        PointList beveledPoints = new PointList();
        beveledPoints.addPoint(this.getPoints().getFirstPoint());
        int i = 1;
        while (i < this.getPoints().size() - 1) {
            Point bevore = this.getPoints().getPoint(i - 1);
            Point after = this.getPoints().getPoint(i + 1);
            int verDistance = Math.abs(bevore.y - after.y);
            int horDistance = Math.abs(bevore.y - after.y);
            int bevelSize = 5;
            if (verDistance < 10) {
                bevelSize = verDistance / 2;
            }
            if (horDistance < 10) {
                bevelSize = horDistance / 2;
            }
            beveledPoints.addPoint(HideableConnection.calcualtedBeveledPoint(this.getPoints().getPoint(i), bevore, bevelSize));
            beveledPoints.addPoint(HideableConnection.calcualtedBeveledPoint(this.getPoints().getPoint(i), after, bevelSize));
            ++i;
        }
        beveledPoints.addPoint(this.getPoints().getLastPoint());
        g.drawPolyline(beveledPoints);
    }

    private static Point calcualtedBeveledPoint(Point refPoint, Point otherPoint, int bevelSize) {
        if (refPoint.x - otherPoint.x == 0) {
            return new Point(refPoint.x, refPoint.y + (refPoint.y - otherPoint.y > 0 ? -bevelSize : bevelSize));
        }
        return new Point(refPoint.x + (refPoint.x - otherPoint.x > 0 ? -bevelSize : bevelSize), refPoint.y);
    }
}

