/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.LinkConstraints;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;

public class EventConnectionCreateCommand
extends AbstractConnectionCreateCommand {
    public EventConnectionCreateCommand(FBNetwork parent) {
        super(parent);
    }

    @Override
    protected Connection createConnectionElement() {
        return LibraryElementFactory.eINSTANCE.createEventConnection();
    }

    @Override
    public boolean canExecute() {
        if (!super.canExecute()) {
            return false;
        }
        if (this.duplicateConnection()) {
            return false;
        }
        return LinkConstraints.canExistEventConnection((Event)this.getSource(), (Event)this.getDestination());
    }

    private boolean duplicateConnection() {
        for (Connection con : this.getSource().getInputConnections()) {
            if (con.getSource() != this.getDestination() && con.getDestination() != this.getDestination()) continue;
            return true;
        }
        for (Connection con : this.getSource().getOutputConnections()) {
            if (con.getSource() != this.getDestination() && con.getDestination() != this.getDestination()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected AbstractConnectionCreateCommand createMirroredConnectionCommand(FBNetwork fbNetwork) {
        return new EventConnectionCreateCommand(fbNetwork);
    }

    @Override
    protected Class getInterfaceType() {
        return Event.class;
    }
}

