/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeviceParametersDialog
extends Dialog {
    private Device device;
    private List<VarDeclaration> selectedProperties = new ArrayList<VarDeclaration>();

    public DeviceParametersDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public List<VarDeclaration> getSelectedProperties() {
        return this.selectedProperties;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(composite, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(1808));
        if (this.device != null) {
            this.selectedProperties = DeploymentCoordinator.INSTANCE.getSelectedDeviceProperties(this.device);
            for (VarDeclaration varDecl : this.device.getVarDeclarations()) {
                Button bt = new Button(main, 32);
                bt.setData((Object)varDecl);
                bt.setText(varDecl.getName());
                if (varDecl.getName().equals("MGR_ID")) {
                    bt.setEnabled(false);
                }
                if (this.selectedProperties != null) {
                    bt.setSelection(this.selectedProperties.contains(varDecl));
                } else {
                    this.selectedProperties = new ArrayList<VarDeclaration>();
                    bt.setSelection(false);
                }
                bt.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (((Button)e.getSource()).getSelection()) {
                            DeviceParametersDialog.this.selectedProperties.add((VarDeclaration)((Button)e.getSource()).getData());
                        } else {
                            DeviceParametersDialog.this.selectedProperties.remove(((Button)e.getSource()).getData());
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        }
        return composite;
    }

    public Device getDevice() {
        return this.device;
    }
}

