/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.annotations;

import java.text.Collator;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.DeviceTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.Palette.SegmentTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.impl.PaletteEntryImpl;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;

public final class PaletteAnnotations {
    public static EList<AdapterTypePaletteEntry> getAdapterTypesSorted(Palette palette) {
        EMap<String, AdapterTypePaletteEntry> adapterList = palette.getAdapterTypes();
        return ECollections.asEList(adapterList.entrySet().stream().map(entry -> (AdapterTypePaletteEntry)entry.getValue()).sorted((o1, o2) -> Collator.getInstance().compare(o1.getLabel(), o2.getLabel())).collect(Collectors.toList()));
    }

    public static void addTypeEntry(Palette palette, PaletteEntry entry) {
        entry.setPalette(palette);
        if (entry instanceof AdapterTypePaletteEntry) {
            palette.getAdapterTypes().put((Object)entry.getLabel(), (Object)((AdapterTypePaletteEntry)entry));
        } else if (entry instanceof DeviceTypePaletteEntry) {
            palette.getDeviceTypes().put((Object)entry.getLabel(), (Object)((DeviceTypePaletteEntry)entry));
        } else if (entry instanceof FBTypePaletteEntry) {
            palette.getFbTypes().put((Object)entry.getLabel(), (Object)((FBTypePaletteEntry)entry));
        } else if (entry instanceof ResourceTypeEntry) {
            palette.getResourceTypes().put((Object)entry.getLabel(), (Object)((ResourceTypeEntry)entry));
        } else if (entry instanceof SegmentTypePaletteEntry) {
            palette.getSegmentTypes().put((Object)entry.getLabel(), (Object)((SegmentTypePaletteEntry)entry));
        } else if (entry instanceof SubApplicationTypePaletteEntry) {
            palette.getSubAppTypes().put((Object)entry.getLabel(), (Object)((SubApplicationTypePaletteEntry)entry));
        } else {
            Activator.getDefault().logError("Unknown pallet entry to be added to palette: " + entry.getClass().getName());
        }
    }

    public static void removeTypeEntry(Palette palette, PaletteEntry entry) {
        if (entry instanceof AdapterTypePaletteEntry) {
            palette.getAdapterTypes().remove((Object)entry.getLabel());
        } else if (entry instanceof DeviceTypePaletteEntry) {
            palette.getDeviceTypes().remove((Object)entry.getLabel());
        } else if (entry instanceof FBTypePaletteEntry) {
            palette.getFbTypes().remove((Object)entry.getLabel());
        } else if (entry instanceof ResourceTypeEntry) {
            palette.getResourceTypes().remove((Object)entry.getLabel());
        } else if (entry instanceof SegmentTypePaletteEntry) {
            palette.getSegmentTypes().remove((Object)entry.getLabel());
        } else if (entry instanceof SubApplicationTypePaletteEntry) {
            palette.getSubAppTypes().remove((Object)entry.getLabel());
        } else {
            Activator.getDefault().logError("Unknown palette entry to be removed from palette: " + entry.getClass().getName());
        }
    }

    public static LibraryElement loadType(PaletteEntryImpl paletteEntryImpl) {
        LibraryElement retval = null;
        try {
            TypeImporter importer = paletteEntryImpl.getTypeImporter(paletteEntryImpl.getPalette());
            retval = importer.importType(paletteEntryImpl.getFile());
        }
        catch (TypeImportException e) {
            Activator.getDefault().logError("Error loading type: " + paletteEntryImpl.getFile().getName(), e);
        }
        if (retval == null) {
            Activator.getDefault().logError("Error loading type: " + paletteEntryImpl.getFile().getName());
        }
        return retval;
    }

    private PaletteAnnotations() {
        throw new UnsupportedOperationException("The utility class PaletteAnnotations should not be instatiated");
    }
}

