/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OtherAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.TextAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;

public class FBTImporter
extends TypeImporter {
    private Map<String, VarDeclaration> variables = new HashMap<String, VarDeclaration>();
    private Map<String, Event> inputEvents = new HashMap<String, Event>();
    private Map<String, Event> outputEvents = new HashMap<String, Event>();
    private Map<String, AdapterDeclaration> adapters = new HashMap<String, AdapterDeclaration>();
    private Map<String, PositionableElement> adapterPositions = new HashMap<String, PositionableElement>();
    private Map<String, List<ECAction>> algorithmNameECActionMapping = new HashMap<String, List<ECAction>>();
    private Map<String, ECState> ecStates = new HashMap<String, ECState>();
    private Map<Event, List<String>> withList = new HashMap<Event, List<String>>();
    private Palette palette;

    @Override
    protected FBType getType() {
        return (FBType)super.getType();
    }

    protected Palette getPalette() {
        return this.palette;
    }

    protected void setPalette(Palette palette) {
        this.palette = palette;
    }

    public FBTImporter(Palette palette) {
        this.palette = palette;
    }

    protected FBTImporter(XMLStreamReader reader, Palette palette) {
        super(reader);
        this.palette = palette;
    }

    @Override
    protected LibraryElement createType() {
        FBType newType = LibraryElementFactory.eINSTANCE.createFBType();
        newType.setService(LibraryElementFactory.eINSTANCE.createService());
        return newType;
    }

    @Override
    protected String getStartElementName() {
        return "FBType";
    }

    @Override
    protected CommonElementImporter.IChildHandler getTypeChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getType());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getType());
                    break;
                }
                case "CompilerInfo": {
                    this.parseCompilerInfo(this.getType());
                    break;
                }
                case "InterfaceList": {
                    this.getType().setInterfaceList(this.parseInterfaceList("InterfaceList"));
                    break;
                }
                case "BasicFB": {
                    this.setType(FBTImporter.convertToBasicType(this.getType()));
                    this.parseBasicFB((BasicFBType)this.getType());
                    break;
                }
                case "SimpleFB": {
                    this.setType(FBTImporter.convertToSimpleType(this.getType()));
                    this.parseSimpleFB((SimpleFBType)this.getType());
                    break;
                }
                case "FBNetwork": {
                    this.setType(FBTImporter.convertToCompositeType(this.getType()));
                    this.parseFBNetwork((CompositeFBType)this.getType());
                    break;
                }
                case "Service": {
                    this.parseService(this.getType());
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    public LibraryElement importType(IFile typeFile) throws TypeImportException {
        LibraryElement newType = super.importType(typeFile);
        if (newType instanceof BasicFBType || newType instanceof CompositeFBType || newType instanceof ServiceInterfaceFBType || newType instanceof SimpleFBType || newType instanceof SubAppType) {
            return newType;
        }
        return FBTImporter.convertToServiceInterfaceType((FBType)newType);
    }

    protected void parseService(FBType type) throws TypeImportException, XMLStreamException {
        String rightInterface = this.getAttributeValue("RightInterface");
        if (rightInterface == null) {
            throw new TypeImportException(Messages.FBTImporter_SERVICE_INTERFACE_RIGHTINTERFACE_EXCEPTION);
        }
        ServiceInterface rightInter = LibraryElementFactory.eINSTANCE.createServiceInterface();
        rightInter.setName(rightInterface);
        type.getService().setRightInterface(rightInter);
        String leftInterface = this.getAttributeValue("LeftInterface");
        if (leftInterface == null) {
            throw new TypeImportException(Messages.FBTImporter_SERVICE_INTERFACE_LEFTINTERFACE_EXCEPTION);
        }
        ServiceInterface leftInter = LibraryElementFactory.eINSTANCE.createServiceInterface();
        leftInter.setName(leftInterface);
        type.getService().setLeftInterface(leftInter);
        String comment = this.getAttributeValue("Comment");
        if (comment != null) {
            type.setComment(comment);
        }
        this.processChildren("Service", name -> {
            if ("ServiceSequence".equals(name)) {
                this.parseServiceSequence(type);
                return true;
            }
            return false;
        });
    }

    private void parseServiceSequence(FBType type) throws TypeImportException, XMLStreamException {
        ServiceSequence serviceSequence = LibraryElementFactory.eINSTANCE.createServiceSequence();
        this.readNameCommentAttributes(serviceSequence);
        this.processChildren("ServiceSequence", name -> {
            if ("ServiceTransaction".equals(name)) {
                this.parseServiceTransaction(serviceSequence, type);
                return true;
            }
            return false;
        });
        type.getService().getServiceSequence().add((Object)serviceSequence);
    }

    private void parseServiceTransaction(ServiceSequence serviceSequence, FBType type) throws TypeImportException, XMLStreamException {
        ServiceTransaction serviceTransaction = LibraryElementFactory.eINSTANCE.createServiceTransaction();
        this.processChildren("ServiceTransaction", name -> {
            switch (name) {
                case "InputPrimitive": {
                    this.parseInputPrimitive(serviceTransaction, type);
                    break;
                }
                case "OutputPrimitive": {
                    this.parseOutputPrimitive(serviceTransaction, type);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        serviceSequence.getServiceTransaction().add((Object)serviceTransaction);
    }

    private void parseOutputPrimitive(ServiceTransaction serviceTransaction, FBType type) throws TypeImportException, XMLStreamException {
        OutputPrimitive outputPrimitive = LibraryElementFactory.eINSTANCE.createOutputPrimitive();
        this.parsePrimitive(type, outputPrimitive);
        this.proceedToEndElementNamed("OutputPrimitive");
        serviceTransaction.getOutputPrimitive().add((Object)outputPrimitive);
    }

    private void parsePrimitive(FBType type, Primitive outputPrimitive) throws TypeImportException {
        String interFace = this.getAttributeValue("Interface");
        if (interFace != null) {
            if (interFace.equals(type.getService().getLeftInterface().getName())) {
                outputPrimitive.setInterface(type.getService().getLeftInterface());
            } else if (interFace.equals(type.getService().getRightInterface().getName())) {
                outputPrimitive.setInterface(type.getService().getRightInterface());
            }
        } else {
            throw new TypeImportException(Messages.FBTImporter_OUTPUT_PRIMITIVE_EXCEPTION);
        }
        String event = this.getAttributeValue(this.getEventElement());
        if (event == null) {
            throw new TypeImportException(Messages.FBTImporter_OUTPUT_PRIMITIVE_EVENT_EXCEPTION);
        }
        outputPrimitive.setEvent(event);
        String parameters = this.getAttributeValue("Parameters");
        if (parameters != null) {
            outputPrimitive.setParameters(parameters);
        }
    }

    private void parseInputPrimitive(ServiceTransaction serviceTransaction, FBType type) throws TypeImportException, XMLStreamException {
        InputPrimitive inputPrimitive = LibraryElementFactory.eINSTANCE.createInputPrimitive();
        this.parsePrimitive(type, inputPrimitive);
        this.proceedToEndElementNamed("InputPrimitive");
        serviceTransaction.setInputPrimitive(inputPrimitive);
    }

    private static FBType convertToServiceInterfaceType(FBType type) {
        ServiceInterfaceFBType serviceType = LibraryElementFactory.eINSTANCE.createServiceInterfaceFBType();
        FBTImporter.copyGeneralTypeInformation(serviceType, type);
        return serviceType;
    }

    private static void copyGeneralTypeInformation(FBType dstType, FBType srcType) {
        dstType.setName(srcType.getName());
        dstType.setComment(srcType.getComment());
        dstType.setCompilerInfo(srcType.getCompilerInfo());
        dstType.setInterfaceList(srcType.getInterfaceList());
        dstType.setIdentification(srcType.getIdentification());
        dstType.getVersionInfo().addAll(srcType.getVersionInfo());
        dstType.setService(srcType.getService());
    }

    private void parseFBNetwork(CompositeFBType type) throws TypeImportException, XMLStreamException {
        FBNetwork fbNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        this.adapters.values().forEach(adapter -> this.addAdapterFB(fbNetwork, (AdapterDeclaration)adapter, this.palette));
        FBNetworkImporter fbnInmporter = new FBNetworkImporter(this.palette, fbNetwork, type.getInterfaceList(), this.getReader());
        type.setFBNetwork(fbnInmporter.parseFBNetwork("FBNetwork"));
    }

    private void addAdapterFB(FBNetwork fbNetwork, AdapterDeclaration adapter, Palette palette) {
        AdapterFB aFB = LibraryElementFactory.eINSTANCE.createAdapterFB();
        aFB.setPaletteEntry(palette.getAdapterTypeEntry(adapter.getTypeName()));
        aFB.setAdapterDecl(adapter);
        aFB.setName(adapter.getName());
        PositionableElement position = this.adapterPositions.get(adapter.getName());
        if (position == null) {
            aFB.setX(0);
            aFB.setY(0);
        } else {
            aFB.setX(position.getX());
            aFB.setY(position.getY());
        }
        if (aFB.getType() != null && aFB.getType().getInterfaceList() != null) {
            aFB.setInterface((InterfaceList)EcoreUtil.copy((EObject)aFB.getType().getInterfaceList()));
        } else {
            aFB.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        }
        fbNetwork.getNetworkElements().add((Object)aFB);
    }

    private static FBType convertToCompositeType(FBType type) {
        CompositeFBType compositeType = LibraryElementFactory.eINSTANCE.createCompositeFBType();
        FBTImporter.copyGeneralTypeInformation(compositeType, type);
        return compositeType;
    }

    private void parseBasicFB(BasicFBType type) throws TypeImportException, XMLStreamException {
        this.processChildren("BasicFB", name -> {
            switch (name) {
                case "InternalVars": {
                    this.parseInternalVars(type);
                    break;
                }
                case "ECC": {
                    this.parseECC(type);
                    break;
                }
                case "Algorithm": {
                    Algorithm alg = this.parseAlgorithm();
                    if (alg == null) break;
                    type.getAlgorithm().add((Object)alg);
                    List<ECAction> list = this.algorithmNameECActionMapping.get(alg.getName());
                    if (list == null) break;
                    for (ECAction action : list) {
                        action.setAlgorithm(alg);
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
    }

    private void parseSimpleFB(SimpleFBType type) throws TypeImportException, XMLStreamException {
        this.processChildren("SimpleFB", name -> {
            switch (name) {
                case "InternalVars": {
                    this.parseInternalVars(type);
                    break;
                }
                case "Algorithm": {
                    type.setAlgorithm(this.parseAlgorithm());
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
    }

    private Algorithm parseAlgorithm() throws TypeImportException, XMLStreamException {
        String name = this.getAttributeValue("Name");
        String comment = this.getAttributeValue("Comment");
        INamedElement retVal = null;
        block12: while (this.getReader().hasNext()) {
            int event;
            block18: {
                event = this.getReader().next();
                if (1 != event) break block18;
                switch (this.getReader().getLocalName()) {
                    case "FBD": {
                        throw new TypeImportException("Algorithm: Unsupported Algorithmtype (only ST and Other possible)!");
                    }
                    case "ST": {
                        retVal = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
                        this.parseST((STAlgorithm)retVal);
                        continue block12;
                    }
                    case "LD": {
                        throw new TypeImportException("Algorithm: Unsupported Algorithmtype (only ST and Other possible)!");
                    }
                    case "Other": {
                        retVal = LibraryElementFactory.eINSTANCE.createOtherAlgorithm();
                        this.parseOtherAlg((OtherAlgorithm)retVal);
                        continue block12;
                    }
                    default: {
                        throw new XMLStreamException("Unexpected xml child (" + this.getReader().getLocalName() + ") found!");
                    }
                }
            }
            if (2 != event) continue;
            if (this.getReader().getLocalName().equals("Algorithm")) break;
            throw new XMLStreamException("Unexpected xml end tag found in Algorithm: " + this.getReader().getLocalName());
        }
        if (retVal != null) {
            retVal.setName(name);
            retVal.setComment(comment);
        }
        return retVal;
    }

    private void parseOtherAlg(OtherAlgorithm alg) throws TypeImportException, XMLStreamException {
        String language = this.getAttributeValue("Language");
        if (language == null) {
            throw new TypeImportException(Messages.FBTImporter_OTHER_ALG_MISSING_LANG_EXCEPTION);
        }
        alg.setLanguage(language);
        this.parseAlgorithmText(alg);
        this.proceedToEndElementNamed("Other");
    }

    private void parseST(STAlgorithm st) throws TypeImportException, XMLStreamException {
        this.parseAlgorithmText(st);
        this.proceedToEndElementNamed("ST");
    }

    private void parseAlgorithmText(TextAlgorithm alg) throws TypeImportException, XMLStreamException {
        String text = this.getAttributeValue("Text");
        if (text != null) {
            alg.setText(text);
        } else {
            StringBuilder algText = new StringBuilder();
            while (this.getReader().hasNext() && 4 == this.getReader().next()) {
                algText.append(this.getReader().getText());
            }
            alg.setText(algText.toString());
        }
    }

    private void parseECC(BasicFBType type) throws TypeImportException, XMLStreamException {
        ECC ecc = LibraryElementFactory.eINSTANCE.createECC();
        this.processChildren("ECC", name -> {
            switch (name) {
                case "ECState": {
                    this.parseECState(ecc);
                    break;
                }
                case "ECTransition": {
                    this.parseECTransition(ecc);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        type.setECC(ecc);
    }

    private void parseECTransition(ECC ecc) throws TypeImportException, XMLStreamException {
        ECTransition ecTransition = LibraryElementFactory.eINSTANCE.createECTransition();
        String source = this.getAttributeValue("Source");
        if (source != null) {
            ECState state = this.ecStates.get(source);
            if (state != null) {
                ecTransition.setSource(state);
            }
        } else {
            throw new TypeImportException(Messages.FBTImporter_ECTRANSITION_SOURCE_EXCEPTION);
        }
        String destination = this.getAttributeValue("Destination");
        if (destination != null) {
            ECState state = this.ecStates.get(destination);
            if (state != null) {
                ecTransition.setDestination(state);
            }
        } else {
            throw new TypeImportException(Messages.FBTImporter_ECTRANSITION_DEST_EXCEPTION);
        }
        String condition = this.getAttributeValue("Condition");
        if (condition == null) {
            throw new TypeImportException(Messages.FBTImporter_ECTRANASITION_CONDITION_EXCEPTION);
        }
        this.validateTransitionCondition(ecTransition, condition);
        String comment = this.getAttributeValue("Comment");
        if (comment != null) {
            ecTransition.setComment(comment);
        }
        this.getXandY(ecTransition);
        this.proceedToEndElementNamed("ECTransition");
        ecc.getECTransition().add((Object)ecTransition);
    }

    private void validateTransitionCondition(ECTransition ecTransition, String condition) {
        String[] split = condition.split("&", 2);
        Event event = this.inputEvents.get(split[0].trim());
        String expression = event != null ? (split.length > 1 ? split[1].trim() : "") : ((event = this.inputEvents.get((split = condition.split("\\[", 2))[0].trim())) != null ? (split.length > 1 ? split[1].substring(0, split[1].lastIndexOf(93)).trim() : "") : (condition.startsWith("[") ? condition.substring(1, condition.lastIndexOf(93)) : condition));
        ecTransition.setConditionEvent(event);
        ecTransition.setConditionExpression(expression);
    }

    private void parseECState(ECC ecc) throws TypeImportException, XMLStreamException {
        ECState state = LibraryElementFactory.eINSTANCE.createECState();
        this.readNameCommentAttributes(state);
        this.getXandY(state);
        this.processChildren("ECState", name -> {
            if ("ECAction".equals(name)) {
                this.parseECAction(state);
                return true;
            }
            return false;
        });
        if (ecc.getECState().isEmpty()) {
            ecc.setStart(state);
        }
        ecc.getECState().add((Object)state);
        this.ecStates.put(state.getName(), state);
    }

    private void parseECAction(ECState type) throws XMLStreamException {
        Event outp;
        String output;
        ECAction ecAction = LibraryElementFactory.eINSTANCE.createECAction();
        String algorithm = this.getAttributeValue("Algorithm");
        if (algorithm != null) {
            if (this.algorithmNameECActionMapping.containsKey(algorithm)) {
                this.algorithmNameECActionMapping.get(algorithm).add(ecAction);
            } else {
                ArrayList<ECAction> temp = new ArrayList<ECAction>();
                temp.add(ecAction);
                this.algorithmNameECActionMapping.put(algorithm, temp);
            }
        }
        if ((output = this.getAttributeValue("Output")) != null && (outp = this.outputEvents.get(output)) != null) {
            ecAction.setOutput(outp);
        }
        this.proceedToEndElementNamed("ECAction");
        type.getECAction().add((Object)ecAction);
    }

    private void parseInternalVars(BaseFBType type) throws TypeImportException, XMLStreamException {
        this.processChildren("InternalVars", name -> {
            if ("VarDeclaration".equals(name)) {
                VarDeclaration v = this.parseVarDeclaration();
                type.getInternalVars().add((Object)v);
                return true;
            }
            return false;
        });
    }

    private static FBType convertToBasicType(FBType type) {
        BasicFBType basicType = LibraryElementFactory.eINSTANCE.createBasicFBType();
        FBTImporter.copyGeneralTypeInformation(basicType, type);
        return basicType;
    }

    private static FBType convertToSimpleType(FBType type) {
        SimpleFBType simpleType = LibraryElementFactory.eINSTANCE.createSimpleFBType();
        FBTImporter.copyGeneralTypeInformation(simpleType, type);
        return simpleType;
    }

    protected InterfaceList parseInterfaceList(String interfaceListName) throws TypeImportException, XMLStreamException {
        InterfaceList interfaceList = LibraryElementFactory.eINSTANCE.createInterfaceList();
        String inputEventListName = this.getEventInputElement();
        String outputEventListName = this.getEventOutputElement();
        this.processChildren(interfaceListName, name -> {
            block17: {
                block18: {
                    block16: {
                        if (!inputEventListName.equals(name)) break block16;
                        this.parseEventList(interfaceList.getEventInputs(), inputEventListName, true);
                        break block17;
                    }
                    if (!outputEventListName.equals(name)) break block18;
                    this.parseEventList(interfaceList.getEventOutputs(), outputEventListName, false);
                    break block17;
                }
                switch (name) {
                    case "InputVars": {
                        this.parseVariableList("InputVars", interfaceList.getInputVars());
                        interfaceList.getInputVars().forEach(v -> {
                            this.variables.put(v.getName(), (VarDeclaration)v);
                            v.setIsInput(true);
                        });
                        break;
                    }
                    case "OutputVars": {
                        this.parseVariableList("OutputVars", interfaceList.getOutputVars());
                        interfaceList.getOutputVars().forEach(v -> {
                            VarDeclaration varDeclaration = this.variables.put(v.getName(), (VarDeclaration)v);
                        });
                        break;
                    }
                    case "Sockets": {
                        this.parseAdapterList(interfaceList.getSockets(), "Sockets", true);
                        break;
                    }
                    case "Plugs": {
                        this.parseAdapterList(interfaceList.getPlugs(), "Plugs", false);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        });
        this.processWiths();
        return interfaceList;
    }

    protected String getEventOutputElement() {
        return "EventOutputs";
    }

    protected String getEventInputElement() {
        return "EventInputs";
    }

    private void parseVariableList(String nodeName, EList<VarDeclaration> varList) throws TypeImportException, XMLStreamException {
        this.processChildren(nodeName, name -> {
            if (name.equals("VarDeclaration")) {
                varList.add((Object)this.parseVarDeclaration());
                return true;
            }
            return false;
        });
    }

    private void parseAdapterList(EList<AdapterDeclaration> adpaterList, String adpaterListName, boolean isInput) throws TypeImportException, XMLStreamException {
        this.processChildren(adpaterListName, name -> {
            if ("AdapterDeclaration".equals(name)) {
                AdapterDeclaration a = this.parseAdapterDeclaration();
                a.setIsInput(isInput);
                this.adapters.put(a.getName(), a);
                adpaterList.add((Object)a);
                if (a.getType() != null && a.getType().getInterfaceList() != null) {
                    if (isInput) {
                        this.addAdapterEventInputs(a.getType().getInterfaceList().getEventOutputs(), a);
                        this.addAdapterEventOutputs(a.getType().getInterfaceList().getEventInputs(), a);
                    } else {
                        this.addAdapterEventInputs(a.getType().getInterfaceList().getEventInputs(), a);
                        this.addAdapterEventOutputs(a.getType().getInterfaceList().getEventOutputs(), a);
                    }
                }
                return true;
            }
            return false;
        });
    }

    private void addAdapterEventOutputs(EList<Event> eventOutputs, AdapterDeclaration a) {
        for (Event event : eventOutputs) {
            AdapterEvent ae = ImportUtils.createAdapterEvent(event, a);
            this.outputEvents.put(ae.getName(), ae);
        }
    }

    private void addAdapterEventInputs(EList<Event> eventInputs, AdapterDeclaration a) {
        for (Event event : eventInputs) {
            AdapterEvent ae = ImportUtils.createAdapterEvent(event, a);
            this.inputEvents.put(ae.getName(), ae);
        }
    }

    private AdapterDeclaration parseAdapterDeclaration() throws TypeImportException, XMLStreamException {
        AdapterDeclaration a = LibraryElementFactory.eINSTANCE.createAdapterDeclaration();
        this.readNameCommentAttributes(a);
        String typeName = this.getAttributeValue("Type");
        if (typeName != null) {
            AdapterTypePaletteEntry entry = this.palette.getAdapterTypeEntry(typeName);
            a.setPaletteEntry(entry);
            AdapterType dataType = null;
            if (entry != null) {
                dataType = entry.getType();
            }
            a.setTypeName(typeName);
            if (dataType != null) {
                a.setType(dataType);
            }
        } else {
            throw new TypeImportException(Messages.FBTImporter_ADAPTER_DECLARATION_TYPE_EXCEPTION);
        }
        PositionableElement pos = LibraryElementFactory.eINSTANCE.createPositionableElement();
        this.getXandY(pos);
        this.adapterPositions.put(a.getName(), pos);
        this.proceedToEndElementNamed("AdapterDeclaration");
        return a;
    }

    protected void processWiths() {
        this.withList.entrySet().forEach(entry -> {
            Event e = (Event)entry.getKey();
            ((List)entry.getValue()).forEach(varName -> {
                VarDeclaration v = this.variables.get(varName);
                if (v != null) {
                    With withConstruct = LibraryElementFactory.eINSTANCE.createWith();
                    withConstruct.setVariables(v);
                    e.getWith().add((Object)withConstruct);
                }
            });
        });
    }

    private void parseEventList(EList<Event> eventList, String eventListName, boolean isInput) throws TypeImportException, XMLStreamException {
        String eventName = this.getEventElement();
        this.processChildren(eventListName, name -> {
            if (eventName.equals(name)) {
                Event e = this.parseEvent(eventName);
                e.setIsInput(isInput);
                if (isInput) {
                    this.inputEvents.put(e.getName(), e);
                } else {
                    this.outputEvents.put(e.getName(), e);
                }
                eventList.add((Object)e);
                return true;
            }
            return false;
        });
    }

    protected String getEventElement() {
        return "Event";
    }

    private Event parseEvent(String eventName) throws TypeImportException, XMLStreamException {
        Event e = LibraryElementFactory.eINSTANCE.createEvent();
        e.setType(EventTypeLibrary.getInstance().getType(null));
        this.readNameCommentAttributes(e);
        ArrayList withVars = new ArrayList();
        this.processChildren(eventName, name -> {
            if ("With".equals(name)) {
                String val = this.getAttributeValue("Var");
                if (val != null) {
                    withVars.add(val);
                }
                this.proceedToEndElementNamed("With");
                return true;
            }
            return false;
        });
        if (!withVars.isEmpty()) {
            this.withList.put(e, withVars);
        }
        return e;
    }
}

