/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;

public abstract class AbstractReconnectConnectionCommand
extends Command {
    private final FBNetwork parent;
    private final ReconnectRequest request;
    private DeleteConnectionCommand deleteConnectionCmd;
    private AbstractConnectionCreateCommand connectionCreateCmd;

    public AbstractReconnectConnectionCommand(String label, ReconnectRequest request, FBNetwork parent) {
        super(label);
        this.request = request;
        this.parent = parent;
    }

    public ReconnectRequest getRequest() {
        return this.request;
    }

    protected FBNetwork getParent() {
        return this.parent;
    }

    public boolean canExecute() {
        EditPart source = null;
        EditPart target = null;
        if (this.request.getType().equals("Reconnection target")) {
            source = this.request.getConnectionEditPart().getSource();
            target = this.request.getTarget();
        } else if (this.request.getType().equals("Reconnection source")) {
            source = this.request.getTarget();
            target = this.request.getConnectionEditPart().getTarget();
        }
        if (source instanceof InterfaceEditPart && target instanceof InterfaceEditPart) {
            IInterfaceElement sourceIE = ((InterfaceEditPart)source).getModel();
            IInterfaceElement targetIE = ((InterfaceEditPart)target).getModel();
            return this.checkSourceAndTarget(sourceIE, targetIE);
        }
        return false;
    }

    public void execute() {
        Connection con = (Connection)this.request.getConnectionEditPart().getModel();
        this.deleteConnectionCmd = new DeleteConnectionCommand(con);
        this.connectionCreateCmd = this.createConnectionCreateCommand(this.parent);
        if (this.request.getType().equals("Reconnection target")) {
            this.doReconnectTarget();
        }
        if (this.request.getType().equals("Reconnection source")) {
            this.doReconnectSource();
        }
        this.connectionCreateCmd.setArrangementConstraints(con.getDx1(), con.getDx2(), con.getDy());
        this.deleteConnectionCmd.execute();
        this.connectionCreateCmd.execute();
    }

    protected void doReconnectSource() {
        this.connectionCreateCmd.setSource(((InterfaceEditPart)this.request.getTarget()).getModel());
        this.connectionCreateCmd.setDestination(((InterfaceEditPart)this.request.getConnectionEditPart().getTarget()).getModel());
    }

    protected void doReconnectTarget() {
        this.connectionCreateCmd.setSource(((InterfaceEditPart)this.request.getConnectionEditPart().getSource()).getModel());
        this.connectionCreateCmd.setDestination(((InterfaceEditPart)this.request.getTarget()).getModel());
    }

    public void redo() {
        this.deleteConnectionCmd.redo();
        this.connectionCreateCmd.redo();
    }

    public void undo() {
        this.connectionCreateCmd.undo();
        this.deleteConnectionCmd.undo();
    }

    protected abstract AbstractConnectionCreateCommand createConnectionCreateCommand(FBNetwork var1);

    protected abstract boolean checkSourceAndTarget(IInterfaceElement var1, IInterfaceElement var2);
}

