/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.utilities.CreationPopupDialog;
import org.eclipse.fordiac.ide.application.utilities.ICreationExecutor;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.Abstract4DIACUIPlugin;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.fordiac.ide.util.dnd.TransferDataSelectionFBParameter;
import org.eclipse.fordiac.ide.util.dnd.TransferDataSelectionOfFb;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ListFBCreateCommand
extends FBCreateCommand {
    private FBTypePaletteEntry[] typeList;
    private TransferDataSelectionOfFb[] selectionList;
    private AutomationSystem system;

    public ListFBCreateCommand(FBTypePaletteEntry[] type, FBNetwork parent, int x, int y) {
        super(null, parent, x, y);
        this.typeList = (FBTypePaletteEntry[])type.clone();
        this.selectionList = null;
        this.system = parent.getAutomationSystem();
    }

    public ListFBCreateCommand(TransferDataSelectionOfFb[] fbList, FBNetwork parent, int x, int y) {
        super(null, parent, x, y);
        this.typeList = null;
        this.selectionList = (TransferDataSelectionOfFb[])fbList.clone();
        this.system = parent.getAutomationSystem();
    }

    public boolean canExecute() {
        if (this.typeList != null) {
            return this.typeList.length != 0;
        }
        if (this.selectionList != null) {
            return this.selectionList.length != 0;
        }
        return false;
    }

    private void executeTransferData() {
        CreationPopupDialog pd = new CreationPopupDialog(Display.getCurrent().getActiveShell(), 540676, true, false, false, false, false, null, null, this.typeList, new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof FBTypePaletteEntry) {
                    return ((FBTypePaletteEntry)element).getLabel();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof FBTypePaletteEntry) {
                    return FordiacImage.ICON_FB.getImage();
                }
                return super.getImage(element);
            }
        }, new ICreationExecutor(){

            @Override
            public void execute(Object res) {
                if (res instanceof TransferDataSelectionOfFb) {
                    TransferDataSelectionOfFb element = (TransferDataSelectionOfFb)res;
                    FBTypePaletteEntry entry = ListFBCreateCommand.this.system.getPalette().getFBTypeEntry(element.getFbTypeName());
                    if (entry != null) {
                        element.setTypePaletteEntry(entry);
                        ListFBCreateCommand.this.setPaletteEntry(element.getTypePaletteEntry());
                        ListFBCreateCommand.super.execute();
                        for (TransferDataSelectionFBParameter fbParametert : element.getFbParameters()) {
                            IInterfaceElement fbInterfaceElement = ListFBCreateCommand.this.getElement().getInterfaceElement(fbParametert.getName());
                            if (!(fbInterfaceElement instanceof VarDeclaration)) continue;
                            Value val = ((VarDeclaration)fbInterfaceElement).getValue();
                            val.setValue(fbParametert.getValue());
                        }
                    } else {
                        Abstract4DIACUIPlugin.statusLineErrorMessage((String)Messages.ListFBCreateCommand_FBTypeNotFound);
                    }
                }
            }
        }){};
        pd.open();
    }

    private void executeFBTypePalette() {
        CreationPopupDialog pd = new CreationPopupDialog(Display.getCurrent().getActiveShell(), 540676, true, false, false, false, false, null, null, this.typeList, new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof FBTypePaletteEntry) {
                    return ((FBTypePaletteEntry)element).getLabel();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof FBTypePaletteEntry) {
                    return FordiacImage.ICON_FB.getImage();
                }
                return super.getImage(element);
            }
        }, new ICreationExecutor(){

            @Override
            public void execute(Object res) {
                if (res instanceof FBTypePaletteEntry) {
                    ListFBCreateCommand.this.setPaletteEntry((FBTypePaletteEntry)res);
                    ListFBCreateCommand.super.execute();
                }
            }
        }){};
        pd.open();
    }

    public void execute() {
        if (this.selectionList != null && this.system != null) {
            this.executeTransferData();
        }
        if (this.typeList != null) {
            this.executeFBTypePalette();
        }
    }
}

