/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.utilities;

import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.util.dnd.TransferDataSelectionOfFb;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;

public abstract class FbTypeTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private AutomationSystem system;

    public FbTypeTemplateTransferDropTargetListener(EditPartViewer viewer, AutomationSystem system) {
        super(viewer);
        this.system = system;
    }

    protected void handleDragOver() {
        super.handleDragOver();
        this.getCurrentEvent().feedback = 24;
        if (TemplateTransfer.getInstance().getTemplate() == null) {
            this.getCurrentEvent().detail = 0;
            this.getCurrentEvent().operations = 0;
        } else if (TemplateTransfer.getInstance().getTemplate() instanceof FBTypePaletteEntry) {
            FBTypePaletteEntry entry = (FBTypePaletteEntry)TemplateTransfer.getInstance().getTemplate();
            AutomationSystem paletteSystem = entry.getPalette().getAutomationSystem();
            if (paletteSystem == null && this.system == null || paletteSystem != null && this.system != null && this.system.equals(paletteSystem)) {
                this.getCurrentEvent().detail = 1;
            } else {
                this.getCurrentEvent().detail = 0;
                this.getCurrentEvent().operations = 0;
            }
        }
    }

    protected void handleDrop() {
        if (!(this.getCurrentEvent().data instanceof FBTypePaletteEntry || this.getCurrentEvent().data instanceof SubApplicationTypePaletteEntry || this.getCurrentEvent().data instanceof TransferDataSelectionOfFb[])) {
            return;
        }
        super.handleDrop();
        TemplateTransfer.getInstance().setTemplate(null);
    }

    protected void updateTargetRequest() {
        SnapToHelper helper;
        super.updateTargetRequest();
        if (this.getTargetEditPart() != null && (helper = (SnapToHelper)this.getTargetEditPart().getAdapter(SnapToHelper.class)) != null) {
            PrecisionPoint preciseLocation = new PrecisionPoint(this.getDropLocation());
            PrecisionPoint result = new PrecisionPoint(this.getDropLocation());
            CreateRequest req = this.getCreateRequest();
            helper.snapPoint((Request)req, 192, preciseLocation, result);
            req.setLocation(result.getCopy());
        }
    }
}

