/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef;

import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.events.MouseEvent;

public class AdvancedScrollingGraphicalViewer
extends ScrollingGraphicalViewer {
    public void reveal(EditPart part) {
        if (!(part instanceof ConnectionEditPart)) {
            super.reveal(part);
        }
    }

    public void checkScrollPositionDuringDrag(MouseEvent me) {
        if (!this.getControl().getBounds().contains(me.x, me.y)) {
            Point newLocation = this.getNewScrollPosition(me);
            this.getFigureCanvas().scrollSmoothTo(newLocation.x, newLocation.y);
        }
    }

    public void checkScrollPositionDuringDragBounded(MouseEvent me, Point border) {
        this.checkScrollPositionDuringDrag(me);
        me.x = AdvancedScrollingGraphicalViewer.boundCoordinate(me.x, border.x, this.getFigureCanvas().getViewport().getHorizontalRangeModel());
        me.y = AdvancedScrollingGraphicalViewer.boundCoordinate(me.y, border.y, this.getFigureCanvas().getViewport().getVerticalRangeModel());
    }

    private static int boundCoordinate(int mousePos, int border, RangeModel rangeModel) {
        int retVal = mousePos;
        int min = rangeModel.getMinimum() - rangeModel.getValue();
        int max = rangeModel.getMaximum() - rangeModel.getMinimum() - rangeModel.getValue();
        if (retVal < min) {
            retVal = min + border;
        } else if (retVal > max) {
            retVal = max - border;
        }
        return retVal;
    }

    private Point getNewScrollPosition(MouseEvent me) {
        Point newLocation = this.getViewLocation();
        newLocation.x += AdvancedScrollingGraphicalViewer.getScrollDelta(me.x, this.getControl().getBounds().x, this.getControl().getBounds().width);
        newLocation.y += AdvancedScrollingGraphicalViewer.getScrollDelta(me.y, this.getControl().getBounds().y, this.getControl().getBounds().height);
        return newLocation;
    }

    public Point getViewLocation() {
        return this.getFigureCanvas().getViewport().getViewLocation();
    }

    private static int getScrollDelta(int mousePos, int controlPos, int length) {
        if (mousePos < controlPos) {
            return mousePos - controlPos;
        }
        if (controlPos + length < mousePos) {
            return mousePos - (controlPos + length);
        }
        return 0;
    }

    public void scrollByOffset(int dx, int dy) {
        Point location = this.getViewLocation();
        this.getFigureCanvas().scrollSmoothTo(location.x + dx, location.y + dy);
    }

    public org.eclipse.swt.graphics.Point getFigureCanvasSize() {
        return this.getFigureCanvas().getSize();
    }
}

