/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.routers;

import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.LinkEditPart;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.SegmentEditPart;

public class LinkConnectionRouter
extends AbstractRouter {
    private LinkEditPart linkEditPart;

    public LinkConnectionRouter(LinkEditPart linkEditPart) {
        this.linkEditPart = linkEditPart;
    }

    public void route(Connection connection) {
        PointList points = connection.getPoints();
        points.removeAllPoints();
        Point startPoint = this.getStartPoint(connection);
        Point endPoint = this.getEndPoint(connection);
        Point bendPoint = null;
        startPoint.x = endPoint.x;
        connection.translateToRelative((Translatable)startPoint);
        connection.translateToRelative((Translatable)endPoint);
        if (this.linkEditPart.getSource() != null) {
            Rectangle segmentBounds = ((SegmentEditPart)this.linkEditPart.getSource()).getFigure().getBounds();
            if (startPoint.x < segmentBounds.x) {
                startPoint.x = segmentBounds.x;
                startPoint.y = segmentBounds.getCenter().y;
                bendPoint = new Point(endPoint.x, startPoint.y);
            } else if (segmentBounds.right() < startPoint.x) {
                startPoint.x = segmentBounds.right();
                startPoint.y = segmentBounds.getCenter().y;
                bendPoint = new Point(endPoint.x, startPoint.y);
            }
        }
        points.addPoint(startPoint);
        if (bendPoint != null) {
            points.addPoint(bendPoint);
        }
        points.addPoint(endPoint);
        connection.setPoints(points);
    }
}

