/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.gef.dnd.ParameterValueTemplateTransfer;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.virtualDNS.VirtualDNSCollection;
import org.eclipse.fordiac.ide.model.virtualDNS.VirtualDNSEntry;
import org.eclipse.fordiac.ide.model.virtualDNS.VirtualDNSFactory;
import org.eclipse.fordiac.ide.model.virtualDNS.VirtualDNSManagement;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceDiagramEditor;
import org.eclipse.fordiac.ide.systemconfiguration.Messages;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationEditor;
import org.eclipse.fordiac.ide.systemconfiguration.views.VirtualDNSCollectionProvider;
import org.eclipse.fordiac.ide.systemconfiguration.views.VirtualDNSEntryLabelProvider;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.VirtualDNSTagProvider;
import org.eclipse.fordiac.ide.systemmanagement.extension.ITagProvider;
import org.eclipse.fordiac.ide.ui.Abstract4DIACUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.ViewPart;

public class VirtualDNSViewer
extends ViewPart
implements ISelectionListener {
    private AutomationSystem system;
    private CCombo availableDNS;
    private VirtualDNSManagement management;
    private FilteredTree filteredTree;
    private final List<VirtualDNSCollection> dnsCollection = new ArrayList<VirtualDNSCollection>();
    private VirtualDNSCollection selectedCollection;
    private Button selected;
    private Button delete;
    private Button newConfiguration;
    private ITagProvider provider;
    private Composite sectionClient;
    private String viewName;
    private IAction deleteEntryAction;
    private static final String DEFAULT_VARIABLE_NAME = "localhost";
    private static final String DEFAULT_VALUE = "127.0.0.1";

    public void createPartControl(Composite parent) {
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        this.viewName = this.getPartName();
        this.sectionClient = new Composite(parent, 0);
        this.sectionClient.setLayout((Layout)new GridLayout(4, false));
        Label configLabel = new Label(this.sectionClient, 0);
        configLabel.setText(String.valueOf(Messages.virtualDNSConfigurationTitle) + ":");
        this.availableDNS = new CCombo(this.sectionClient, 17);
        this.availableDNS.setSize(240, -1);
        this.availableDNS.addListener(13, e -> this.handleDNSSelection(this.availableDNS.getSelectionIndex()));
        this.newConfiguration = new Button(this.sectionClient, 0);
        this.newConfiguration.setText(Messages.virtualDNSNewConfiguration);
        this.newConfiguration.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.newConfiguration.addListener(13, e -> {
            if (this.system != null) {
                this.creteNewConfiguration();
            }
        });
        this.delete = new Button(this.sectionClient, 0);
        this.delete.setText(Messages.virtualDNSDeleteConfiguration);
        this.delete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.delete.addListener(13, e -> {
            this.management.getAvailableDNSCollections().remove((Object)this.selectedCollection);
            this.updateAvailableCollections();
            SystemManager.INSTANCE.saveTagProvider(this.system, this.provider);
        });
        this.selected = new Button(this.sectionClient, 32);
        this.selected.setText(Messages.virtualDNSActiveConfigurationText);
        GridData gridData = new GridData(4, 2, true, false);
        gridData.horizontalIndent = 5;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.selected.setLayoutData((Object)gridData);
        this.selected.addListener(13, e -> {
            if (this.selected.getSelection()) {
                this.management.setActiveVirtualDNS(this.selectedCollection);
            }
        });
        this.createDNSEntryList(this.sectionClient);
        this.updateAvailableCollections();
    }

    private void createDNSEntryList(Composite parent) {
        PatternFilter patternFilter = new PatternFilter();
        this.filteredTree = new FilteredTree(parent, 68352, patternFilter, true);
        GridData treeGridData = new GridData();
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.horizontalSpan = 4;
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.horizontalAlignment = 4;
        treeGridData.verticalAlignment = 4;
        treeGridData.minimumHeight = 200;
        this.filteredTree.setLayoutData((Object)treeGridData);
        this.createFirstColumn();
        this.createSecondColumn();
        this.filteredTree.getViewer().getTree().setHeaderVisible(true);
        this.filteredTree.getViewer().getTree().setLinesVisible(true);
        this.filteredTree.getViewer().setContentProvider((IContentProvider)new VirtualDNSCollectionProvider());
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new VirtualDNSEntryLabelProvider());
        this.filteredTree.getViewer().addPostSelectionChangedListener(event -> {
            boolean enabled = !this.filteredTree.getViewer().getSelection().isEmpty() && ((IStructuredSelection)this.filteredTree.getViewer().getSelection()).getFirstElement() instanceof VirtualDNSEntry;
            this.deleteEntryAction.setEnabled(enabled);
        });
        MenuManager popupMenu = new MenuManager();
        NewEntryAction newRowAction = new NewEntryAction();
        popupMenu.add((IAction)newRowAction);
        this.deleteEntryAction = new DeleteEntryAction();
        this.deleteEntryAction.setEnabled(false);
        popupMenu.add(this.deleteEntryAction);
        Menu menu = popupMenu.createContextMenu((Control)this.filteredTree.getViewer().getTree());
        this.filteredTree.getViewer().getTree().setMenu(menu);
        Transfer[] types = new Transfer[]{ParameterValueTemplateTransfer.getInstance()};
        ParameterValueTemplateTransfer type = ParameterValueTemplateTransfer.getInstance();
        int operations = 1;
        DragSource source = new DragSource((Control)this.filteredTree.getViewer().getTree(), operations);
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener((Transfer)type){
            private final /* synthetic */ Transfer val$type;
            {
                this.val$type = transfer;
            }

            public void dragFinished(DragSourceEvent event) {
                int cfr_ignored_0 = event.detail;
            }

            public void dragSetData(DragSourceEvent event) {
                Object obj;
                ISelection sel;
                if (this.val$type.isSupportedType(event.dataType) && (sel = VirtualDNSViewer.this.filteredTree.getViewer().getSelection()) instanceof StructuredSelection && (obj = ((StructuredSelection)sel).getFirstElement()) instanceof VirtualDNSEntry) {
                    event.data = "%" + ((VirtualDNSEntry)obj).getName() + "%";
                }
            }

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = VirtualDNSViewer.this.filteredTree.getViewer().getTree().getSelection();
                if (selection.length == 0) {
                    event.doit = false;
                }
            }
        });
    }

    private boolean variableNameAlreadyExists(VirtualDNSEntry element, String newValue) {
        for (VirtualDNSEntry entry : this.selectedCollection.getVirtualDNSEntries()) {
            if (!entry.getName().equals(newValue) || entry.equals(element)) continue;
            return true;
        }
        return false;
    }

    private void createFirstColumn() {
        TreeViewerColumn column1 = new TreeViewerColumn(this.filteredTree.getViewer(), 0);
        column1.getColumn().setText(Messages.virtualDNSFirstColumnTitle);
        column1.getColumn().setWidth(200);
        column1.setEditingSupport(new EditingSupport(column1.getViewer()){

            protected void setValue(Object element, Object value) {
                if (element instanceof VirtualDNSEntry) {
                    if (VirtualDNSViewer.this.variableNameAlreadyExists((VirtualDNSEntry)element, value.toString())) {
                        Abstract4DIACUIPlugin.statusLineErrorMessage((String)MessageFormat.format(Messages.virtualDNSSameVariableNameError, value.toString()));
                    } else {
                        ((VirtualDNSEntry)element).setName(value.toString());
                        VirtualDNSViewer.this.filteredTree.getViewer().refresh();
                        SystemManager.INSTANCE.saveTagProvider(VirtualDNSViewer.this.system, VirtualDNSViewer.this.provider);
                    }
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof VirtualDNSEntry) {
                    return ((VirtualDNSEntry)element).getName();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)VirtualDNSViewer.this.filteredTree.getViewer().getTree());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
    }

    private void createSecondColumn() {
        TreeViewerColumn column2 = new TreeViewerColumn(this.filteredTree.getViewer(), 0);
        column2.getColumn().setText(Messages.virtualDNSSecondColumnTitle);
        column2.getColumn().setWidth(800);
        column2.setEditingSupport(new EditingSupport(column2.getViewer()){

            protected void setValue(Object element, Object value) {
                if (element instanceof VirtualDNSEntry) {
                    ((VirtualDNSEntry)element).setValue(value.toString());
                    VirtualDNSViewer.this.filteredTree.getViewer().refresh();
                    SystemManager.INSTANCE.saveTagProvider(VirtualDNSViewer.this.system, VirtualDNSViewer.this.provider);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof VirtualDNSEntry) {
                    return ((VirtualDNSEntry)element).getValue();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)VirtualDNSViewer.this.filteredTree.getViewer().getTree());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
    }

    private void updateAvailableCollections() {
        this.availableDNS.removeAll();
        this.dnsCollection.clear();
        int index = -1;
        if (this.management != null) {
            this.dnsCollection.addAll((Collection<VirtualDNSCollection>)this.management.getAvailableDNSCollections());
            index = this.dnsCollection.indexOf(this.management.getActiveVirtualDNS());
        }
        for (VirtualDNSCollection collection : this.dnsCollection) {
            this.availableDNS.add(collection.getName());
            SystemManager.INSTANCE.saveTagProvider(this.system, this.provider);
        }
        this.availableDNS.select(index);
        this.availableDNS.getParent().layout();
        this.handleDNSSelection(index);
    }

    private void handleDNSSelection(int index) {
        this.selected.setSelection(false);
        this.selected.setEnabled(false);
        this.delete.setEnabled(false);
        if (index > -1) {
            this.filteredTree.getViewer().setInput((Object)this.dnsCollection.get(index));
            this.selectedCollection = this.dnsCollection.get(index);
            if (this.selectedCollection != null) {
                this.selected.setSelection(this.selectedCollection.equals(this.management.getActiveVirtualDNS()));
                this.selected.setEnabled(true);
                this.delete.setEnabled(true);
            }
        } else {
            this.filteredTree.getViewer().setInput(null);
        }
    }

    private void updateContents() {
        if (this.system != null) {
            this.setPartName(String.valueOf(this.viewName) + ": " + this.system.getName());
            try {
                Object object;
                this.provider = SystemManager.INSTANCE.getTagProvider(Class.forName(VirtualDNSTagProvider.class.getName()), this.system);
                if (this.provider != null && (object = this.provider.getModelObject()) instanceof VirtualDNSManagement) {
                    this.management = (VirtualDNSManagement)object;
                    this.newConfiguration.setEnabled(true);
                    this.availableDNS.setEnabled(true);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            this.setPartName(this.viewName);
            this.provider = null;
            this.management = null;
            this.availableDNS.setEnabled(false);
            this.newConfiguration.setEnabled(false);
            this.delete.setEnabled(false);
        }
        this.updateAvailableCollections();
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.sectionClient != null && !this.sectionClient.isDisposed()) {
            AutomationSystem newSystem = null;
            if (part instanceof SystemConfigurationEditor) {
                newSystem = ((SystemConfigurationEditor)part).getSystem();
            } else if (part instanceof FBNetworkEditor) {
                newSystem = ((FBNetworkEditor)part).getSystem();
            } else if (part instanceof ResourceDiagramEditor) {
                newSystem = ((ResourceDiagramEditor)part).getSystem();
            } else if (part instanceof CommonNavigator && selection instanceof TreeSelection) {
                newSystem = VirtualDNSViewer.handleSystemTreeSelection((TreeSelection)selection);
            }
            if (newSystem != null && this.system != newSystem) {
                this.system = newSystem;
                this.updateContents();
            }
        }
    }

    private static AutomationSystem handleSystemTreeSelection(TreeSelection selection) {
        AutomationSystem retval = null;
        if (1 == selection.size()) {
            Object obj = selection.getFirstElement();
            if (obj instanceof AutomationSystem) {
                retval = (AutomationSystem)obj;
            } else if (obj instanceof SystemConfiguration) {
                retval = ((SystemConfiguration)obj).getAutomationSystem();
            } else if (obj instanceof Device) {
                retval = ((Device)obj).getAutomationSystem();
            } else if (obj instanceof Resource) {
                retval = ((Resource)obj).getAutomationSystem();
            } else if (obj instanceof Application) {
                retval = ((Application)obj).getAutomationSystem();
            } else if (obj instanceof SubApp) {
                VirtualDNSViewer.getSystemForSubApp((SubApp)obj);
            } else if (obj instanceof FB && ((FB)obj).eContainer() instanceof FBNetwork) {
                FBNetwork fbNetwork = (FBNetwork)((FB)obj).eContainer();
                retval = fbNetwork.getAutomationSystem();
            }
        }
        return retval;
    }

    private static AutomationSystem getSystemForSubApp(SubApp obj) {
        AutomationSystem retval = null;
        FBNetwork fbNetwork = (FBNetwork)obj.eContainer();
        retval = fbNetwork.getAutomationSystem();
        return retval;
    }

    private void creteNewConfiguration() {
        IInputValidator validator = newText -> newText.length() > 0 ? null : Messages.virtualDNSEmptyNameError;
        InputDialog collectionName = new InputDialog(Display.getDefault().getActiveShell(), Messages.virtualDNSNewConfigTitle, Messages.virtualDNSNewConfigMessage, Messages.virtualDNSNewConfigDefaultName, validator);
        collectionName.setBlockOnOpen(true);
        int ret = collectionName.open();
        if (ret == 0) {
            VirtualDNSCollection collection = VirtualDNSFactory.eINSTANCE.createVirtualDNSCollection();
            collection.setName(collectionName.getValue());
            if (this.management != null) {
                this.management.getAvailableDNSCollections().add((Object)collection);
                if (this.management.getActiveVirtualDNS() != null) {
                    this.cloneActiveVirtualDNSEntries(collection, this.management.getActiveVirtualDNS());
                }
                this.updateAvailableCollections();
            }
        }
    }

    private void cloneActiveVirtualDNSEntries(VirtualDNSCollection collection, VirtualDNSCollection activeVirtualDNS) {
        for (VirtualDNSEntry srcEntry : activeVirtualDNS.getVirtualDNSEntries()) {
            VirtualDNSEntry entry = VirtualDNSFactory.eINSTANCE.createVirtualDNSEntry();
            entry.setName(srcEntry.getName());
            entry.setValue(Messages.virtualDNSValueNotSet);
            collection.getVirtualDNSEntries().add((Object)entry);
        }
    }

    private class DeleteEntryAction
    extends Action {
        public DeleteEntryAction() {
            super(Messages.virtualDNSDeleteEntryButtonText);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        }

        public void run() {
            if (VirtualDNSViewer.this.selectedCollection != null && ((IStructuredSelection)VirtualDNSViewer.this.filteredTree.getViewer().getSelection()).getFirstElement() instanceof VirtualDNSEntry) {
                VirtualDNSEntry entry = (VirtualDNSEntry)((IStructuredSelection)VirtualDNSViewer.this.filteredTree.getViewer().getSelection()).getFirstElement();
                VirtualDNSViewer.this.selectedCollection.getVirtualDNSEntries().remove((Object)entry);
                VirtualDNSViewer.this.filteredTree.getViewer().refresh();
            }
        }
    }

    private class NewEntryAction
    extends Action {
        public NewEntryAction() {
            super(Messages.virtualDNSNewEntryButtonText);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        }

        public void run() {
            VirtualDNSEntry entry = VirtualDNSFactory.eINSTANCE.createVirtualDNSEntry();
            String nameToAssing = VirtualDNSViewer.DEFAULT_VARIABLE_NAME;
            int counter = 1;
            while (VirtualDNSViewer.this.variableNameAlreadyExists(null, nameToAssing)) {
                nameToAssing = "localhost_" + Integer.toString(counter++);
            }
            entry.setName(nameToAssing);
            entry.setValue(VirtualDNSViewer.DEFAULT_VALUE);
            if (VirtualDNSViewer.this.selectedCollection != null) {
                VirtualDNSViewer.this.selectedCollection.getVirtualDNSEntries().add((Object)entry);
            }
            VirtualDNSViewer.this.filteredTree.getViewer().refresh();
        }
    }
}

